% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.galamm}
\alias{confint.galamm}
\title{Confidence intervals for model parameters}
\usage{
\method{confint}{galamm}(object, parm, level = 0.95, method = "Wald", ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{parm}{Parameters for which to compute intervals. Use \code{"theta"} to
get all variance parameters, \code{"beta"} to get all fixed regression
coefficients, \code{"lambda"} to get all factor loadings, and
\code{"weights"} to get all weights. The parameter can also be given as a
numeric vector with indices specifying the parameters.}

\item{level}{Confidence level. Defaults to 0.95.}

\item{method}{Currently only "Wald" is available.}

\item{...}{Other arguments passed on to other methods. Currently not used.}
}
\value{
A matrix with the requested confidence intervals.
}
\description{
Confidence intervals for model parameters
}
\examples{
# Poisson GLMM
count_mod <- galamm(
  formula = y ~ lbas * treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

confint(count_mod, parm = "beta", level = .99)

}
\seealso{
\code{\link[=fixef.galamm]{fixef.galamm()}} for fixed effects, \code{\link[=coef.galamm]{coef.galamm()}} for
coefficients more generally, and \code{\link[=vcov.galamm]{vcov.galamm()}} for the variance-covariance
matrix. \code{\link[=confint]{confint()}} is the generic function.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
