% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_field_values.R
\name{search_field_values}
\alias{search_field_values}
\title{Search for valid options of a categorical field}
\usage{
search_field_values(field, limit = 20)
}
\arguments{
\item{field}{\code{string}: field to return the categories for. Use
\code{\link[=search_fields]{search_fields()}} to view valid fields.}

\item{limit}{\code{numeric}: maximum number of categories to return. 20 by default.}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble)
containing columns \code{field} (user-supplied) and \code{category} (i.e. field values).
}
\description{
When building a set of filters with \code{\link[=galah_filter]{galah_filter()}}, a user can
use this function to check that the values provided are valid options.
}
\section{Examples}{


Find valid values you can use to filter or categorise results for the field
"basisOfRecord"\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_field_values("basisOfRecord")
#> # A tibble: 8 x 2
#>   field         category           
#>   <chr>         <chr>              
#> 1 basisOfRecord HUMAN_OBSERVATION  
#> 2 basisOfRecord PRESERVED_SPECIMEN 
#> 3 basisOfRecord OBSERVATION        
#> 4 basisOfRecord MACHINE_OBSERVATION
#> 5 basisOfRecord MATERIAL_SAMPLE    
#> 6 basisOfRecord UNKNOWN            
#> 7 basisOfRecord LIVING_SPECIMEN    
#> 8 basisOfRecord FOSSIL_SPECIMEN
}\if{html}{\out{</div>}}

Find valid values to filter or categorise results for the field
"stateProvince"\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_field_values("stateProvince")
#> # A tibble: 20 x 2
#>    field         category                    
#>    <chr>         <chr>                       
#>  1 stateProvince New South Wales             
#>  2 stateProvince Victoria                    
#>  3 stateProvince Queensland                  
#>  4 stateProvince South Australia             
#>  5 stateProvince Western Australia           
#>  6 stateProvince Northern Territory          
#>  7 stateProvince Tasmania                    
#>  8 stateProvince Australian Capital Territory
#>  9 stateProvince Canterbury Land District    
#> 10 stateProvince Wellington Land District    
#> 11 stateProvince Southland Land District     
#> 12 stateProvince Nelson Land District        
#> 13 stateProvince North Auckland Land District
#> 14 stateProvince Otago Land District         
#> 15 stateProvince North Island                
#> 16 stateProvince Morobe                      
#> 17 stateProvince Westland Land District      
#> 18 stateProvince Marlborough Land District   
#> 19 stateProvince South Auckland              
#> 20 stateProvince South Island
}\if{html}{\out{</div>}}

Use these values to with \code{\link[=galah_filter]{galah_filter()}} tp filter results of \code{atlas_}
functions. For example, we can return the number of records only from
Tasmania\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
  galah_filter(stateProvince == "Tasmania") |>
  atlas_counts()
#> # A tibble: 1 x 1
#>     count
#>     <int>
#> 1 4504419
}\if{html}{\out{</div>}}
}

\seealso{
See \code{\link[=search_fields]{search_fields()}} for ways to use information returned
by this function.
}
