% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_media.R
\name{atlas_media}
\alias{atlas_media}
\title{Download images, sounds and videos}
\usage{
atlas_media(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  select = galah_select(group = "basic"),
  download_dir,
  refresh_cache = FALSE
)
}
\arguments{
\item{request}{optional \code{data_rquest} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{select}{\code{data.frame}: generated by a call to
\code{\link[=galah_select]{galah_select()}}}

\item{download_dir}{\code{string}: path to directory to store the downloaded
media in}

\item{refresh_cache}{\code{logical}: if set to \code{TRUE} and
\code{galah_config(caching = TRUE)} then files cached from a previous query will
be replaced by the current query}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble)
of metadata of the downloaded media
}
\description{
In addition to text data describing individual occurrences and their
attributes, ALA stores images, sounds and videos associated with a given
record. \code{atlas_media} allows download of any and all of the media types.
}
\details{
\code{\link[=atlas_occurrences]{atlas_occurrences()}} works by first finding all occurrence records
matching the filter which contain media, then downloading the metadata for the
media and the media files. \code{\link[=galah_filter]{galah_filter()}} can take both filter
relating to occurrences (e.g. basis of records), and filter relating to media
(e.g. type of licence).
It may be beneficial when requesting a large number of records to show a progress
bar by setting \code{verbose = TRUE} in \code{\link[=galah_config]{galah_config()}}.
}
\section{Examples}{


Download Regent Honeyeater multimedia\if{html}{\out{<div class="sourceCode r">}}\preformatted{media_data <- galah_call() |>
    galah_identify("Regent Honeyeater") |>
    galah_filter(year == 2011) |>
    atlas_media(download_dir = "folder/your-directory")
}\if{html}{\out{</div>}}

Specify a single media type to download\if{html}{\out{<div class="sourceCode r">}}\preformatted{media_data <- galah_call(
     galah_identify("Eolophus Roseicapilla") |>
     galah_filter(multimedia == "Sound") |>
     atlas_media()
}\if{html}{\out{</div>}}

Filter to only records with a particular licence type (DOESN'T WORK)\if{html}{\out{<div class="sourceCode r">}}\preformatted{media_data <- galah_call()
      galah_identify("Ornithorhynchus anatinus") |>
      galah_filter(year == 2020,
        license = "http://creativecommons.org/licenses/by-nc/4.0/") |>
       atlas_media()
)
}\if{html}{\out{</div>}}

You might also want to check how many records have media files before you
download them. Do this with \code{\link[=atlas_counts]{atlas_counts()}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
     galah_filter(multimedia == c("Image","Sound","Video")) |>
     galah_group_by(multimedia) |>
     atlas_counts()
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=atlas_counts]{atlas_counts()}} to find the number of records with media- note this
is not necessarily the same as the number of media files, as each record can have
more than one media file associated with it (see examples section for how to do this).
}
