/*
 * Decompiled with CFR 0.152.
 */
package gWidgetsrJava;

import gWidgetsrJava.DateSpan;
import gWidgetsrJava.DateUtils;
import gWidgetsrJava.JXDatePickerFormatterFactory;
import gWidgetsrJava.JXMonthView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class JXDatePicker
extends JComponent {
    protected JFormattedTextField _dateField = new JFormattedTextField(new JXDatePickerFormatterFactory());
    protected JXDatePickerPopup _popup;
    private JButton _popupButton;
    private int _popupButtonWidth = 20;
    private JXMonthView _monthView;
    private Handler _handler;
    private String _actionCommand = "selectionChanged";

    public JXDatePicker() {
        this(System.currentTimeMillis());
    }

    public JXDatePicker(long l) {
        this._dateField.setName("dateField");
        this._dateField.setBorder(null);
        this._handler = new Handler();
        this._popupButton = new JButton();
        this._popupButton.setName("popupButton");
        this._popupButton.setRolloverEnabled(false);
        this._popupButton.addMouseListener(this._handler);
        this._popupButton.addMouseMotionListener(this._handler);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
        InputMap inputMap = this._dateField.getInputMap(0);
        inputMap.put(keyStroke, "COMMIT_EDIT");
        ActionMap actionMap = this._dateField.getActionMap();
        actionMap.put("COMMIT_EDIT", new CommitEditAction());
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(32, 0, false);
        inputMap = this._popupButton.getInputMap(0);
        inputMap.put(keyStroke2, "TOGGLE_POPUP");
        actionMap = this._popupButton.getActionMap();
        actionMap.put("TOGGLE_POPUP", new TogglePopupAction());
        this.add(this._dateField);
        this.add(this._popupButton);
        this.updateUI();
        this._dateField.setValue(new Date(l));
    }

    public void updateUI() {
        int n = UIManager.getInt("JXDatePicker.numColumns");
        if (n == -1) {
            n = 10;
        }
        this._dateField.setColumns(n);
        this._popupButton.setText("V");
        Border border = UIManager.getBorder("JXDatePicker.border");
        if (border == null) {
            border = BorderFactory.createCompoundBorder(LineBorder.createGrayLineBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
        this._dateField.setBorder(border);
    }

    public void setDate(Date date) {
        this._dateField.setValue(date);
    }

    public void setDateInMillis(long l) {
        this._dateField.setValue(new Date(l));
    }

    public Date getDate() {
        return (Date)this._dateField.getValue();
    }

    public long getDateInMillis() {
        return ((Date)this._dateField.getValue()).getTime();
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    public JFormattedTextField.AbstractFormatterFactory getDateFormatterFactory() {
        return this._dateField.getFormatterFactory();
    }

    public void setDateFormatterFactory(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory) {
        this._dateField.setFormatterFactory(abstractFormatterFactory);
    }

    public boolean isEditValid() {
        return this._dateField.isEditValid();
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        this._dateField.setEnabled(bl);
        this._popupButton.setEnabled(bl);
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String string) {
        this._actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this._actionCommand);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        this._dateField.setBounds(insets.left, insets.bottom, n - this._popupButtonWidth, n2);
        this._popupButton.setBounds(n - this._popupButtonWidth + insets.left, insets.bottom, this._popupButtonWidth, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this._dateField.getPreferredSize();
        dimension.width += this._popupButton.getPreferredSize().width;
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    private class JXDatePickerPopup
    extends JPopupMenu
    implements ActionListener {
        private JButton _nextButton;
        private JButton _previousButton;
        private JButton _todayButton;

        public JXDatePickerPopup() {
            JXDatePicker.this._monthView = new JXMonthView();
            JXDatePicker.this._monthView.setActionCommand("MONTH_VIEW");
            JXDatePicker.this._monthView.addActionListener(this);
            JPanel jPanel = new JPanel(new FlowLayout());
            this._previousButton = new JButton("<");
            this._previousButton.setActionCommand("PREVIOUS_MONTH");
            this._previousButton.addActionListener(this);
            this._nextButton = new JButton(">");
            this._nextButton.setActionCommand("NEXT_MONTH");
            this._nextButton.addActionListener(this);
            this._todayButton = new JButton("today");
            this._todayButton.setActionCommand("TODAY");
            this._todayButton.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)JXDatePicker.this._monthView, "Center");
            jPanel.add(this._previousButton);
            jPanel.add(this._todayButton);
            jPanel.add(this._nextButton);
            this.add((Component)jPanel, "North");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("MONTH_VIEW" == string) {
                DateSpan dateSpan = JXDatePicker.this._monthView.getSelectedDateSpan();
                JXDatePicker.this._dateField.setValue(dateSpan.getStartAsDate());
                JXDatePicker.this._popup.setVisible(false);
                JXDatePicker.this.fireActionPerformed();
            } else if ("PREVIOUS_MONTH" == string) {
                JXDatePicker.this._monthView.setFirstDisplayedDate(DateUtils.getPreviousMonth(JXDatePicker.this._monthView.getFirstDisplayedDate()));
            } else if ("NEXT_MONTH" == string) {
                JXDatePicker.this._monthView.setFirstDisplayedDate(DateUtils.getNextMonth(JXDatePicker.this._monthView.getFirstDisplayedDate()));
            } else if ("TODAY" == string) {
                DateSpan dateSpan = new DateSpan(System.currentTimeMillis(), System.currentTimeMillis());
                JXDatePicker.this._monthView.ensureDateVisible(dateSpan.getStart());
            }
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener {
        private boolean _forwardReleaseEvent = false;

        private Handler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!JXDatePicker.this.isEnabled()) {
                return;
            }
            if (JXDatePicker.this._dateField.isEditValid()) {
                try {
                    JXDatePicker.this._dateField.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.toggleShowPopup();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this._forwardReleaseEvent) {
                mouseEvent = SwingUtilities.convertMouseEvent(JXDatePicker.this._popupButton, mouseEvent, JXDatePicker.this._monthView);
                JXDatePicker.this._monthView.dispatchEvent(mouseEvent);
                this._forwardReleaseEvent = false;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this._forwardReleaseEvent = true;
            if (!JXDatePicker.this._popup.isShowing()) {
                return;
            }
            mouseEvent = SwingUtilities.convertMouseEvent(JXDatePicker.this._popupButton, mouseEvent, JXDatePicker.this._monthView);
            JXDatePicker.this._monthView.dispatchEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void toggleShowPopup() {
            if (JXDatePicker.this._popup == null) {
                JXDatePicker.this._popup = new JXDatePickerPopup();
            }
            if (!JXDatePicker.this._popup.isVisible()) {
                if (JXDatePicker.this._dateField.getValue() == null) {
                    JXDatePicker.this._dateField.setValue(new Date(System.currentTimeMillis()));
                }
                DateSpan dateSpan = new DateSpan((Date)JXDatePicker.this._dateField.getValue(), (Date)JXDatePicker.this._dateField.getValue());
                JXDatePicker.this._monthView.setSelectedDateSpan(dateSpan);
                JXDatePicker.this._monthView.ensureDateVisible(((Date)JXDatePicker.this._dateField.getValue()).getTime());
                Point point = JXDatePicker.this._dateField.getLocationOnScreen();
                JXDatePicker.this._popup.show(JXDatePicker.this, 0, JXDatePicker.this.getHeight());
            } else {
                JXDatePicker.this._popup.setVisible(false);
            }
        }
    }

    private class CommitEditAction
    extends AbstractAction {
        public CommitEditAction() {
            super("CommitEditPopup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JXDatePicker.this._dateField.commitEdit();
                JXDatePicker.this._dateField.setValue(JXDatePicker.this._dateField.getValue());
                JXDatePicker.this.fireActionPerformed();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private class TogglePopupAction
    extends AbstractAction {
        public TogglePopupAction() {
            super("TogglePopup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXDatePicker.this._handler.toggleShowPopup();
        }
    }
}

