% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence.R
\name{old_grain_evidence}
\alias{old_grain_evidence}
\alias{setEvidence}
\alias{retractEvidence}
\alias{absorbEvidence}
\alias{getEvidence}
\alias{pEvidence}
\title{Set, update and remove evidence.}
\usage{
setEvidence(
  object,
  nodes = NULL,
  states = NULL,
  evidence = NULL,
  propagate = TRUE,
  details = 0
)

retractEvidence(object, nodes = NULL, propagate = TRUE)

absorbEvidence(object, propagate = TRUE)

getEvidence(object, short = TRUE)

pEvidence(object, evidence = NULL)
}
\arguments{
\item{object}{A "grain" object}

\item{nodes}{A vector of nodes.}

\item{states}{A vector of states (of the nodes given by
'nodes'). Now deprecated; use argument 'evidence' instead.}

\item{evidence}{A list of name=value. See examples below.}

\item{propagate}{Should the network be propagated?}

\item{details}{Debugging information}

\item{short}{If TRUE a dataframe with a summary is returned;
otherwise a list with all details.}
}
\value{
A list of tables with potentials.
}
\description{
Set, update and remove evidence.
}
\note{
\code{setEvidence()} is an improvement of \code{setFinding()}
(and as such \code{setFinding} is obsolete). Users are
recommended to use \code{setEvidence()} in the future.

\code{setEvidence()} allows to specification of "hard evidence" (specific
values for variables) and likelihood evidence (also known as virtual
evidence) for variables.

The syntax of \code{setEvidence()} may change in the future.
}
\examples{

example("grain")
chest_bn <- grain(compileCPT(chest_cpt))

bn2 <- chest_bn |> evidence_add(list(asia="yes", xray="yes"))
bn3 <- chest_bn |> evidence_add(list(asia=c(0.8, 0.1), xray="yes"))

bn2 |> evidence_get()
bn3 |> evidence_get()

bn2 |> evidence_prob()
bn3 |> evidence_prob()

bn2 |> evidence_drop("xray")
bn3 |> evidence_drop("xray")

bn2 |> evidence_drop("xray") |> evidence_get()
bn3 |> evidence_drop("xray") |> evidence_get()


## For backward compatibility these functions are available now but
# may be deprecated later.
bb2 <- setEvidence(chest_bn, c("asia", "xray"), c("yes", "yes"))
bb3 <- setEvidence(chest_bn, c("asia", "xray"), list(c(0.8, 0.2), "yes"))
bb4 <- setFinding(chest_bn, c("asia", "xray"), c("yes", "yes"))

bb2 |> getEvidence()
bb3 |> getEvidence()

bb2 |> retractEvidence("xray")
bb3 |> retractEvidence("xray")

bb2 |> pEvidence()
bb3 |> pEvidence()

bb2 |> retractEvidence("xray") |> getEvidence()
bb3 |> retractEvidence("xray") |> getEvidence()

## Evidence from dataframe
dat <- gRbase::chestSim500[,1:4]
setEvidence(chest_bn, evidence=dat[1,]) |> getEvidence()
dat2 <- lapply(dat, as.character) |> as.data.frame() |> as.matrix()
setEvidence(chest_bn, evidence=dat2[2,]) |> getEvidence()
}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{https://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{setFinding}}, \code{\link{getFinding}},
\code{\link{retractFinding}}, \code{\link{pFinding}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\concept{old_names}
