% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grain-compile.R
\name{grain_compile}
\alias{grain_compile}
\alias{add_jtree}
\alias{compile.grain}
\alias{compile.cpt_grain}
\alias{compile.pot_grain}
\alias{add_jtree.cpt_grain}
\alias{add_jtree.pot_grain}
\alias{add_potential}
\alias{add_potential.cpt_grain}
\alias{add_potential.pot_grain}
\title{Compile a graphical independence network (a Bayesian network)}
\usage{
add_jtree(object, root = NULL)

\method{add_jtree}{cpt_grain}(object, root = NULL)

\method{add_jtree}{pot_grain}(object, root = NULL)

add_potential(object)

\method{add_potential}{cpt_grain}(object)

\method{add_potential}{pot_grain}(object)

\method{compile}{grain}(
  object,
  propagate = FALSE,
  root = NULL,
  control = object$control,
  details = 0,
  ...
)

\method{compile}{cpt_grain}(
  object,
  propagate = FALSE,
  root = NULL,
  control = object$control,
  details = 0,
  ...
)

\method{compile}{pot_grain}(
  object,
  propagate = FALSE,
  root = NULL,
  control = object$control,
  details = 0,
  ...
)
}
\arguments{
\item{object}{A grain object.}

\item{root}{A set of variables which must be in the root of the
junction tree}

\item{propagate}{If TRUE the network is also propagated meaning
that the cliques of the junction tree are calibrated to each
other.}

\item{control}{Controlling the compilation process.}

\item{details}{For debugging info. Do not use.}

\item{\dots}{Currently not used.}
}
\value{
A compiled Bayesian network; an object of class
\code{grain}.
}
\description{
Compiles a Bayesian network. This means creating a
junction tree and establishing clique potentials.
}
\examples{
## To be written

}
\references{
Søren Højsgaard (2012). Graphical Independence
Networks with the gRain Package for R. Journal of Statistical
Software, 46(10), 1-26.
\url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{grain}}, \code{\link[gRbase]{propagate}},
\code{\link[gRbase]{triangulate}}, \code{\link[gRbase]{rip}},
\code{\link[gRbase]{junctionTree}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
