% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotHull2D}
\alias{plotHull2D}
\title{Plot the convex hull of a set of points in 3D.}
\usage{
plotHull2D(
  pts,
  drawPoints = FALSE,
  drawLines = TRUE,
  drawPolygons = TRUE,
  addText = FALSE,
  addRays = FALSE,
  direction = 1,
  latex = FALSE,
  ...
)
}
\arguments{
\item{pts}{A matrix with a point in each row.}

\item{drawPoints}{Draw the points.}

\item{drawLines}{Draw lines of the facets.}

\item{drawPolygons}{Fill the hull.}

\item{addText}{Add text to the points. Currently \code{coord} (coordinates), \code{rownames} (rownames)
and \code{both} supported or a vector with text.}

\item{addRays}{Add the ray defined by \code{direction}.}

\item{direction}{Ray direction. If i'th entry is positive, consider the i'th column of \code{pts}
plus a value greater than on equal zero (minimize objective $i$). If negative, consider the
i'th column of \code{pts} minus a value greater than on equal zero (maximize objective $i$).}

\item{latex}{If \code{True} make latex math labels for TikZ.}

\item{...}{Further arguments passed on the the ggplot plotting functions. This must be done as
lists. Currently the following arguments are supported:
\itemize{
\item \code{argsGeom_point}: A list of arguments for \code{\link[ggplot2:geom_point]{ggplot2::geom_point}}.
\item \code{argsGeom_path}: A list of arguments for \code{\link[ggplot2:geom_path]{ggplot2::geom_path}}.
\item \code{argsGeom_polygon}: A list of arguments for \code{\link[ggplot2:geom_polygon]{ggplot2::geom_polygon}}.
\item \code{argsGeom_label}: A list of arguments for \code{\link[ggplot2:geom_label]{ggplot2::geom_label}}.
}}
}
\value{
The ggplot.
}
\description{
Plot the convex hull of a set of points in 3D.
}
\examples{
pts<-matrix(c(1,1), ncol = 2, byrow = TRUE)
plotHull2D(pts)
pts<-matrix(c(1,1, 2,2), ncol = 2, byrow = TRUE)
plotHull2D(pts, drawPoints = TRUE)
plotHull2D(pts, drawPoints = TRUE, addRays = TRUE, addText = "coord")
plotHull2D(pts, drawPoints = TRUE, addRays = TRUE, direction = -1, addText = "coord")
pts<-matrix(c(1,1, 2,2, 0,1), ncol = 2, byrow = TRUE)
plotHull2D(pts, drawPoints = TRUE, addText = "coord")
plotHull2D(pts, drawPoints = TRUE, addRays = TRUE, addText = "coord")
plotHull2D(pts, drawPoints = TRUE, addRays = TRUE, direction = -1, addText = "coord")

}
