% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{slices}
\alias{slices}
\title{Find all corner points in the slices define for each fixed integer combination.}
\usage{
slices(A, b, type = rep("c", ncol(A)), nonneg = rep(TRUE, ncol(A)),
  collapse = FALSE)
}
\arguments{
\item{A}{The constraint matrix.}

\item{b}{Right hand side.}

\item{type}{A character vector of same length as number of variables. If
entry k is 'i' variable \eqn{k} must be integer and if 'c' continuous.}

\item{nonneg}{A boolean vector of same length as number of variables. If
entry k is TRUE then variable k must be non-negative.}

\item{collapse}{Collapse list to a data frame with unique points.}
}
\value{
A list with the corner points (one entry for each slice).
}
\description{
Find all corner points in the slices define for each fixed integer combination.
}
\examples{
A <- matrix( c(3, -2, 1,2, 4, -2,-3, 2, 1), nc = 3, byrow = TRUE)
b <- c(10,12,3)
slices(A, b, type=c("i","c","i"))

A <- matrix(c(9,10,2,4,-3,2), ncol = 2, byrow = TRUE)
b <- c(90,27,3)
slices(A, b, type=c("c","i"), collapse = TRUE)
}
