% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampSize.R
\name{sampSize}
\alias{sampSize}
\title{Sample size calculations}
\usage{
sampSize(graph, esf, effSize, powerReqFunc, target, corr.sim, alpha,
  corr.test = NULL, type = c("quasirandom", "pseudorandom"),
  upscale = FALSE, n.sim = 10000, verbose = FALSE, ...)
}
\arguments{
\item{graph}{A graph of class \code{\link{graphMCP}}.}

\item{esf}{...}

\item{effSize}{...}

\item{powerReqFunc}{One power requirement function or a list of these. 
% For example \code{function(x) {any(x)}} for at least one rejection or more complex user defined functions like \code{function(x) {(x[1]&&x[3])||(x[2]&&x[4])}}.
If one is interested in the power to reject hypotheses 1 and 3
one could specify: \cr\code{f=function(x) {x[1] && x[3]}}.\cr If the power
of rejecting hypotheses 1 and 2 is also of interest one would use a
(optionally named) list: \cr 
\code{f=list(power1and3=function(x) {x[1] && x[3]},}\cr
\code{power1and2=function(x) {x[1] && x[2]})}.
If the list has no names, the functions will be referenced 
to as "func1", "func2", etc. in the output.}

\item{target}{Target power that should be at least achieved. Either a numeric scalar between 0 and 1 or if parameter \code{powerReqFunc} is a list a numeric vector of the same length as \code{powerReqFunc}.}

\item{corr.sim}{Covariance matrix under the alternative.}

\item{alpha}{...}

\item{corr.test}{Correlation matrix that should be used for the parametric test.
If \code{corr.test==NULL} the Bonferroni based test procedure is used. Can contain
NAs.}

\item{type}{What type of random numbers to use. \code{quasirandom} uses a
randomized Lattice rule, and should be more efficient than
\code{pseudorandom} that uses ordinary (pseudo) random numbers.}

\item{upscale}{Logical. If \code{upscale=FALSE} then for each intersection 
of hypotheses (i.e. each subgraph) a weighted test is performed at the 
possibly reduced level alpha of sum(w)*alpha, 
where sum(w) is the sum of all node weights in this subset.
If \code{upscale=TRUE} all weights are upscaled, so that sum(w)=1.}

\item{n.sim}{...}

\item{verbose}{Logical, whether verbose output should be printed.}

\item{...}{...}

\item{test}{In the parametric case there is more than one way to handle
subgraphs with less than the full alpha. If the parameter \code{test} is
missing, the tests are performed as described by Bretz et al. (2011), i.e.
tests of intersection null hypotheses always exhaust the full alpha level
even if the sum of weights is strictly smaller than one. If
\code{test="simple-parametric"} the tests are performed as defined in
Equation (3) of Bretz et al. (2011).}
}
\value{
...
}
\description{
Sample size calculations
}
\examples{

\dontrun{
graph <- BonferroniHolm(4)
powerReqFunc <- function(x) { (x[1] && x[2]) || x[3] }
#TODO Still causing errors / loops.
#sampSize(graph, alpha=0.05, powerReqFunc, target=0.8, mean=c(6,4,2) )
#sampSize(graph, alpha=0.05, powerReqFunc, target=0.8, mean=c(-1,-1,-1), nsim=100)
sampSize(graph, esf=c(1,1,1,1), effSize=c(1,1,1,1), 
         corr.sim=diag(4), powerReqFunc=powerReqFunc, target=0.8, alpha=0.05)
powerReqFunc=list('all(x[c(1,2)])'=function(x) {all(x[c(1,2)])},
                  'any(x[c(0,1)])'=function(x) {any(x[c(0,1)])})
sampSize(graph=graph, 
         effSize=list("Scenario 1"=c(2, 0.2, 0.2, 0.2), 
                      "Scenario 2"=c(0.2, 4, 0.2, 0.2)), 
         esf=c(0.5, 0.7071067811865476, 0.5, 0.7071067811865476),
         powerReqFunc=powerReqFunc, 
         corr.sim=diag(4), target=c(0.8, 0.8), alpha=0.025)
}
}
