/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.buttons.HorizontalButtonPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.PowerOptionsPanel;
import org.af.gMCP.gui.options.OptionsDialog;
import org.af.gMCP.gui.power.CVPanel;
import org.af.gMCP.gui.power.PDialog;
import org.af.gMCP.gui.power.PowerResultDialog;
import org.af.gMCP.gui.power.PowerResultTableModel;
import org.af.gMCP.gui.power.ScenarioPanel;
import org.af.gMCP.gui.power.SettingsToXML;
import org.af.gMCP.gui.power.UserDefinedPanel;
import org.af.gMCP.gui.power.VariablePanel;
import org.af.jhlir.call.RList;
import org.jdesktop.swingworker.SwingWorker;

public class PowerDialog
extends PDialog
implements ActionListener {
    public PowerDialog(CreateGraphGUI parent) {
        super(parent, "Power Simulation - specify probability distribution of test statistics", true);
        this.config = new File(this.path, "gMCP-power-settings.xml");
        this.pNCP = new ScenarioPanel(this);
        this.tPanel.addTab("Noncentrality Parameter (NCP) Settings", (Component)((Object)this.pNCP));
        this.cvPanel = new CVPanel(this);
        this.tPanel.addTab("Correlation Matrix", this.cvPanel);
        this.userDefinedFunctions = new UserDefinedPanel(this, this.nodes);
        this.tPanel.addTab("User defined power function", this.userDefinedFunctions);
        this.oPanel = new PowerOptionsPanel(parent);
        this.tPanel.addTab("Options", this.oPanel);
        Set<String> variables = parent.getGraphView().getNL().getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        if (variables.size() > 0) {
            this.vp = new VariablePanel(variables);
            this.tPanel.addTab("Variables", this.vp);
        }
        this.getContentPane().add((Component)this.tPanel, this.c);
        this.c.weighty = 0.0;
        ++this.c.gridy;
        this.c.weightx = 0.0;
        this.c.fill = 0;
        this.c.anchor = 13;
        HorizontalButtonPane bp = new HorizontalButtonPane(new String[]{"Help", "Ok", "Cancel"}, new String[]{"help", "OK", "CANCEL"});
        this.getContentPane().add((Component)bp, this.c);
        bp.addActionListener((ActionListener)this);
        if (this.config.exists()) {
            SettingsToXML.loadConfigFromXML(this.config, this);
        }
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setSize(Math.max(870, this.getWidth()), this.getHeight());
        int answer = 1;
        if (this.tmp && !Configuration.getInstance().getClassProperty(this.getClass(), "tellAboutFiles", "yes").equals("no")) {
            JCheckBox tellMeAgain = new JCheckBox("Don't show me this info again.");
            String message = "The settings in this dialog will be saved for further runs in this session.\nIf you want these settings to be automatically saved not only temporarily,\nbut even between sessions, please specify a directory for saving these\nfiles in the options.\nDo you want to open the options dialog now?";
            answer = JOptionPane.showConfirmDialog(parent, new Object[]{message, tellMeAgain}, "Info", 0);
            if (tellMeAgain.isSelected()) {
                Configuration.getInstance().setClassProperty(this.getClass(), "tellAboutFiles", "no");
            }
        }
        if (answer == 0) {
            new OptionsDialog(parent, "Misc");
            this.dispose();
            return;
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        double alpha;
        try {
            alpha = this.parent.getPView().getTotalAlpha();
        }
        catch (Exception e1) {
            return;
        }
        if (e.getActionCommand().equals("OK")) {
            this.userDefinedFunctions.actionPerformed(null);
            if (RControl.getR().eval("any(is.na(" + this.cvPanel.getSigma() + "))").asRLogical().getData()[0]) {
                JOptionPane.showMessageDialog(this, "Correlation matrix for simulation can not contain NAs.", "No NAs allowed", 0);
                this.tPanel.setSelectedComponent(this.cvPanel);
                return;
            }
            SettingsToXML.saveSettingsToXML(this.config, this);
            this.createLongRCommand(alpha);
            this.rCommand = "gMCP:::calcMultiPower(graph=" + this.parent.getGraphView().getNL().getGraphName() + ", alpha=" + alpha + ", ncpL=" + this.pNCP.getNCPString() + "," + "corr.sim = " + this.cvPanel.getSigma() + this.cvPanel.getMatrixForParametricTest() + ", f = " + this.userDefinedFunctions.getUserDefined() + ", n.sim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + ", upscale = " + (Configuration.getInstance().getGeneralConfig().getUpscale() ? "TRUE" : "FALSE") + this.getVariables(false) + ", digits=4" + ")";
            this.parent.glassPane.start();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground() throws Exception {
                    try {
                        RControl.setSeed();
                        RList result = RControl.getR().eval(PowerDialog.this.rCommand).asRList();
                        new PowerResultDialog(PowerDialog.this.parent, "Power Results", result.get(0).asRDataFrame(), result.get(1).asRChar().getData(), PowerDialog.this.longRCommand, PowerResultTableModel.class);
                    }
                    catch (Exception e) {
                        ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e, false);
                    }
                    finally {
                        PowerDialog.this.parent.glassPane.stop();
                    }
                    return null;
                }
            };
            worker.execute();
        }
        if (e.getActionCommand().equals("help")) {
            if (this.tPanel.getSelectedComponent() == this.pNCP) {
                this.parent.openHelp("ncps");
            } else if (this.tPanel.getSelectedComponent() == this.cvPanel) {
                this.parent.openHelp("cormat2");
            } else if (this.tPanel.getSelectedComponent() == this.oPanel) {
                this.parent.openHelp("optNumeric");
            } else if (this.tPanel.getSelectedComponent() == this.userDefinedFunctions) {
                this.parent.openHelp("udpf");
            } else {
                this.parent.openHelp("power");
            }
        } else {
            this.dispose();
        }
    }

    private String getVariables(boolean quote) {
        if (this.vp == null) {
            return "";
        }
        String q = "";
        if (quote) {
            q = "\"";
        }
        return ", variables=" + q + this.vp.getVariables() + q;
    }

    private void createLongRCommand(double alpha) {
        this.longRCommand = "createCalcPowerCall(graph=" + this.parent.getGraphView().getNL().getGraphName() + ", alpha=" + alpha + ", ncpL=\"" + this.pNCP.getNCPString() + "\"" + "," + "corr.sim = " + this.cvPanel.getSigma() + this.cvPanel.getMatrixForParametricTest() + ", f = \"" + this.userDefinedFunctions.getUserDefined() + "\"" + ", n.sim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + ", upscale = " + (Configuration.getInstance().getGeneralConfig().getUpscale() ? "TRUE" : "FALSE") + this.getVariables(true) + ", digits=4" + ", seed=" + Configuration.getInstance().getGeneralConfig().getSeed() + ")";
        this.longRCommand = RControl.getR().eval(this.longRCommand).asRChar().getData()[0];
    }
}

