\name{gMCP}
\alias{gMCP}

\title{
	A graphical approach to sequentially rejective multiple test procedures
}
\description{
	Performs a sequentially rejective multiple test procedure on a graph given unadjusted p-values.
}
\usage{
	gMCP(graph, pvalues, verbose=FALSE)
}

\arguments{
  \item{graph}{
	A graph of class \code{\link{graphMCP}}.
  }
  \item{pvalues}{
  	A numeric vector specifying the p-values for the sequentially rejective MTP.
  } 
  \item{verbose}{Logical scalar.  If \code{TRUE} verbose output is generated during
          sequentially rejection steps.}  
}
\details{
	For details see the given references.
}
\value{
An object of class \code{gMCPResult}, more specifically a list with elements
\item{graphs }{ list of graphs}				
\item{pvalues }{ p-values}
\item{adjPValues }{ adjusted p-values}
}
\references{
Frank Bretz, Willi Maurer, Werner Brannath, Martin Posch:
A graphical approach to sequentially rejective multiple test procedures.
Statistics in Medicine 2009 vol. 28 issue 4 page 586-604. 
\url{http://www.meduniwien.ac.at/fwf_adaptive/papers/bretz_2009_22.pdf}

Strassburger K., Bretz F.:
Compatible simultaneous lower confidence bounds for the Holm procedure and other
Bonferroni based closed tests. Statistics in Medicine 2008; 27:4914-4927.

Hommel G., Bretz F., Maurer W.:
Powerful short-cuts for multiple testing procedures with special reference to 
gatekeeping strategies. Statistics in Medicine 2007; 26:4063-4073.

Guilbaud O.: 
Simultaneous confidence regions corresponding to Holm's stepdown procedure and 
other closed-testing procedures. Biometrical Journal 2008; 50:678-692.
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{graphMCP}}
}
\examples{

g <- createBonferroniHolmGraph(5)

gMCP(g, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7))


}
\keyword{ htest }
\keyword{ graphs }

