/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mutoss.gui.graph.AbstractGraphControl;
import org.mutoss.gui.graph.Node;
import org.mutoss.gui.graph.PPanel;

public class PView
extends JPanel
implements ActionListener {
    JLabel statusBar;
    private AbstractGraphControl control;
    private Vector<PPanel> panels = new Vector();
    CellConstraints cc = new CellConstraints();
    JPanel panel = new JPanel();
    JLabel label = new JLabel("Total \u03b1: 0");
    List<Double> pValues = null;

    public PView(AbstractGraphControl abstractGraphControl) {
        this.control = abstractGraphControl;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 0;
        c.ipady = 0;
        this.add((Component)new JScrollPane(this.panel), c);
    }

    public void addPPanel(Node node) {
        this.panels.add(new PPanel(node, this));
        this.setUp();
    }

    public void savePValues() {
        this.pValues = new Vector<Double>();
        for (PPanel panel : this.panels) {
            this.pValues.add(panel.getP());
        }
    }

    public void restorePValues() {
        for (int i = 0; i < this.pValues.size(); ++i) {
            this.panels.get(i).setP(this.pValues.get(i));
        }
    }

    public void setUp() {
        this.getHeaderPanel();
        int row = 4;
        for (PPanel p : this.panels) {
            int col = 2;
            for (Component c : p.getComponent()) {
                this.panel.add(c, this.cc.xy(col, row));
                col += 2;
            }
            row += 2;
        }
        this.panel.add((Component)this.label, this.cc.xyw(2, row, 7));
        this.panel.revalidate();
    }

    private void getHeaderPanel() {
        this.panel.removeAll();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        for (PPanel p : this.panels) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.panel.setLayout((LayoutManager)layout);
        this.panel.add((Component)new JLabel("Hypothesis"), this.cc.xy(2, 2));
        this.panel.add((Component)new JLabel("Significance Level"), this.cc.xy(4, 2));
        this.panel.add((Component)new JLabel("P-Value"), this.cc.xy(6, 2));
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void updateLabels() {
        double alpha = 0.0;
        for (PPanel p : this.panels) {
            if (p.rejected.booleanValue()) continue;
            alpha += p.w;
        }
        String text = "Total \u03b1: " + ("" + alpha).substring(0, Math.min(7, ("" + alpha).length()));
        if (alpha >= 1.0) {
            this.label.setForeground(Color.RED);
            text = text + "; The total \u03b1 is greater or equal 1!";
        } else {
            this.label.setForeground(Color.BLACK);
        }
        this.label.setText(text);
    }

    public void recalculate() {
        for (PPanel p : this.panels) {
            p.update();
        }
        this.revalidate();
        this.repaint();
    }

    public void newGraph() {
        this.panels.removeAllElements();
    }

    public void removePPanel(Node node) {
        for (int i = this.panels.size() - 1; i >= 0; --i) {
            if (this.panels.get((int)i).node != node) continue;
            this.panel.remove(this.panels.get((int)i).label);
            this.panel.remove(this.panels.get((int)i).jb);
            this.panel.remove(this.panels.get((int)i).pTF);
            this.panel.remove(this.panels.get((int)i).wTF);
            this.panels.remove(i);
        }
        this.setUp();
    }

    public void setTesting(boolean b) {
        PPanel.setTesting(b);
        for (PPanel p : this.panels) {
            p.keyTyped(null);
        }
    }

    public String getPValuesString() {
        String s = "c(";
        for (double p : this.pValues) {
            s = s + p + ", ";
        }
        return s.substring(0, s.length() - 2) + ")";
    }
}

