% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{fx_pspline}
\alias{fx_pspline}
\title{Get frequency of the climate value with p-spline smoothing}
\usage{
fx_pspline(x, bin, show_plot = FALSE)
}
\arguments{
\item{x}{Numeric vector with the modern climate values.}

\item{bin}{Binwidth to get the frequency of the modern climate values, the
curve will be p-spline smoothed later}

\item{show_plot}{Boolean flag to show a plot of \code{fx ~ x}.}
}
\value{
Numeric vector with the frequency of the modern climate values.
}
\description{
Function to get the frequency of the climate value, which will be used to
provide \code{fx} correction for WA-PLS and TWA-PLS.
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")

# Get the frequency of each climate variable fx
fx_pspline_Tmin <- fxTWAPLS::fx_pspline(
  modern_pollen$Tmin,
  bin = 0.02,
  show_plot = TRUE
)
fx_pspline_gdd <- fxTWAPLS::fx_pspline(
  modern_pollen$gdd,
  bin = 20,
  show_plot = TRUE
)
fx_pspline_alpha <- fxTWAPLS::fx_pspline(
  modern_pollen$alpha,
  bin = 0.002,
  show_plot = TRUE
)
}

}
\seealso{
\code{\link{cv.w}}, \code{\link{cv.pr.w}}, and
\code{\link{sse.sample}}
}
