% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{processModel}
\alias{processModel}
\title{Process valid models}
\usage{
processModel(model, global, custom, accumulators, dataDirectories)
}
\arguments{
\item{model}{List with parsed information about the directory structure for
a specific climate model from the user-specified projections directory.
This list is a subset of the list generated by
\code{acquireDirectoryStructure}.}

\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}

\item{custom}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the name of the R function to
use to identify heat waves, alternative upper and lower year boundaries
for the data used to determine threshold temperatures for the heat wave
definition, alternative upper and lower year boundaries
for the projection period of the heat wave datasets being generated).}

\item{accumulators}{The closure generated by
\code{\link{createAccumulators}} that allows you to append model
information and grid location data as you process through models to
a growing list.}

\item{dataDirectories}{A list object, with two elements, one for each of the
two subdirectories included in the main directory. Typically, these will
be separate directories of historical and projection experiments from
climate models. Each element of the list should be named with the name of
the subdirectory and should provide a numeric vector with the starting and
ending years of the data within each of the two subdirectories (e.g.,
\code{list("historical" = c(1990, 1999), "rcp85" = c(2060, 2079))}
for a \code{dataFolder} with historical experiment data for 1990 to 1999
and RCP8.5 projections for 2060 to 2079).}
}
\value{
A list object with processed projections, as well as various other
   elements needed for further processing to identify heat waves.
}
\description{
This function takes any models that are valid, identifies and characterizes
heat waves within projections for each of its ensemble members, writes
those dataframes of heat wave projections out to the user-specified output
directory, and stores information about the models and grid locations.
}

