% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{getBounds}
\alias{getBounds}
\title{Acquire boundaries of time series data}
\usage{
getBounds(times, custom, type)
}
\arguments{
\item{times}{A dataframe containing the time data for one ensemble member's
projections. Each row in this dataframe corresponds to the row with the
same row number in the climate projection dataframe.}

\item{custom}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the name of the R function to
use to identify heat waves, alternative upper and lower year boundaries
for the data used to determine threshold temperatures for the heat wave
definition, alternative upper and lower year boundaries
for the projection period of the heat wave datasets being generated).}

\item{type}{A character vector giving the type of boundaries that are being
checked. Possible values are "threshold", "projections", and "reference".}
}
\value{
A numeric vector containing the number of days spanned by the
   time period, the lower bound of the experiment time
   period as an index specifying the relevant row of the climate projection
   data; and an upper bound of the experiment time period as an index
   specifying the relevant row of the climate projection data.
}
\description{
This function acquires the boundaries of time series data.
}

