% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{RandomMatrixModel}
\alias{Ensemble}
\alias{JacobiMatrix}
\alias{JacobiModel}
\alias{RandomMatrixModel}
\alias{WignerMatrix}
\alias{WignerModel}
\alias{WishartMatrix}
\alias{WishartModel}
\title{Type constructors for random matrices and ensembles of random matrices}
\arguments{
\item{real}{Whether the matrix has real components or not}

\item{n}{Number of rows}

\item{m}{Number of columns}

\item{m1}{Number of columns}

\item{m2}{Number of columns}

\item{sd}{Standard deviation of the sample population}

\item{count}{Number of matrices in the ensemble}

\item{model}{The random matrix model to use}
}
\value{
Returns a model type. Use with \code{\link{rmatrix}} or 
\code{\link{Ensemble}} to generate actual matrices.
}
\description{
Provides type constructors for creating random matrices. Various
studies can be initiated afterward.
}
\section{Usage}{

RandomMatrixModel(real=TRUE, ...)

WignerMatrix(x, model)

WishartModel(n, m, sd=1, ...)

JacobiModel(n, m1, m2, ...)

Ensemble(count, model)
}
\examples{
model <- WignerModel(10)
m <- rmatrix(model)
e <- Ensemble(20, model)
}

