# WARNING - Generated by {fusen} from dev/flat_register_config_file.Rmd: do not edit by hand

dummypackage <- tempfile("registered")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_flat_template(pkg = dummypackage, overwrite = TRUE, open = FALSE))
flat_file <- dev_file[grepl("flat_", dev_file)]

usethis::with_project(dummypackage, {
  test_that("check_not_registered_files returns message if empty", {
    expect_true(inherits(check_not_registered_files, "function"))

    # debugonce(check_not_registered_files)
    expect_message(check_not_registered_files(open = FALSE), "There are no files in the package")
  })

  # Inflate once
  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )

  test_that("guess_flat_origin works", {
    guessed_path <- guess_flat_origin(file.path(dummypackage, "R", "my_median.R"))
    # Relative path
    expect_equal(guessed_path, file.path("dev", "flat_full.Rmd"))

    guessed_path <- guess_flat_origin(file.path(dummypackage, "dev", "0-dev_history.Rmd"))
    expect_true(grepl("No existing source path found", guessed_path))
  })

  test_that("check_not_registered_files works", {
    # All files were registered during inflate
    expect_true(file.exists(file.path(dummypackage, "dev", "config_fusen.yaml")))
    expect_message(out_csv <- check_not_registered_files(open = FALSE),
      regexp = "There are no unregistered files"
    )

    # Delete config file to check if al sub-functions work
    file.remove(file.path(dummypackage, "dev", "config_fusen.yaml"))
    expect_message(out_csv <- check_not_registered_files(open = FALSE),
      regexp = "Some files in your package are not registered in the configuration file"
    )

    content_csv <- read.csv(out_csv, stringsAsFactors = FALSE)
    expect_true(all(names(content_csv) %in% c("type", "path", "origin")))
    expect_equal(content_csv[["type"]], c("R", "R", "test", "test", "vignette"))
    # Relative path
    expect_equal(
      content_csv[["path"]],
      c(
        "R/my_median.R",
        "R/my_other_median.R",
        "tests/testthat/test-my_median.R",
        "tests/testthat/test-my_other_median.R",
        "vignettes/get-started.Rmd"
      )
    )
  })

  test_that("guess_flat_origin output works with df_to_config", {
    out_csv <- "dev/config_not_registered.csv"
    # Include it in df_to_config()

    out_config <- df_to_config(
      df_files = out_csv
    )
    out_config_content <- yaml::read_yaml(out_config)
    expect_true(all(names(out_config_content) %in% c("flat_full.Rmd", "keep")))
    expect_equal(
      names(out_config_content[["flat_full.Rmd"]]),
      c("path", "state", "R", "tests", "vignettes")
    )
    expect_equal(
      out_config_content[["flat_full.Rmd"]][["R"]],
      c("R/my_median.R", "R/my_other_median.R")
    )
    expect_equal(
      out_config_content[["flat_full.Rmd"]][["tests"]],
      c("tests/testthat/test-my_median.R", "tests/testthat/test-my_other_median.R")
    )
    expect_equal(
      out_config_content[["flat_full.Rmd"]][["vignettes"]],
      c("vignettes/get-started.Rmd")
    )

    # rstudioapi::navigateToFile(out_config)
  })

  # Test add a R file manually and include in "keep" after `check_not_registered_files()`
  cat("# test R file\n", file = file.path(dummypackage, "R", "to_keep.R"))

  test_that("check_not_registered_files can help manually fill config", {
    expect_message(out_csv <- check_not_registered_files(open = FALSE), "Some files in your package are not registered in the configuration file")
    content_csv <- read.csv(out_csv, stringsAsFactors = FALSE)
    expect_true(
      grepl(
        "No existing source path found",
        content_csv[grepl("to_keep.R", content_csv[, "path"]), "origin"]
      )
    )

    # Add in the yaml file with `df_to_config()`
    keep_to_add_to_config <- content_csv[grepl("to_keep.R", content_csv[, "path"]), ]
    keep_to_add_to_config$origin <- "keep"

    out_config <- df_to_config(keep_to_add_to_config)
    # rstudioapi::navigateToFile(out_config)
    out_config_content <- yaml::read_yaml(out_config)
    expect_equal(out_config_content$keep$R, "R/to_keep.R")

    expect_message(
      out_csv <- check_not_registered_files(open = FALSE),
      "There are no unregistered files"
    )
    expect_true(is.null(out_csv))

    # Add same file in the yaml file with `df_to_config()` using different origin (existing one, but duplicate R file) ----
    cat("fake flat\n", file = file.path("dev", "flat_other.Rmd"))
    keep_to_add_to_config$origin <- "dev/flat_other.Rmd"

    expect_error(
      df_to_config(keep_to_add_to_config),
      "Some paths would appear multiple times in the future config file."
    )
    out_config_content <- yaml::read_yaml(out_config)
    expect_equal(out_config_content$keep$R, "R/to_keep.R")

    # Add same file in the yaml file with `df_to_config()` using different origin (not existing) ----

    keep_to_add_to_config$origin <- "dev/flat_dont_exists.Rmd"

    expect_error(
      df_to_config(keep_to_add_to_config),
      "Some 'origin' in df_files do not exist: row 1: dev/flat_dont_exists.Rmd"
    )
  })
})

dummypackage <- tempfile("register")
dir.create(dummypackage)
dir.create(file.path(dummypackage, "fusentest"))
dummypackage_fixed <- file.path(dummypackage, "fusentest")
# unlink(dummypackage, recursive = TRUE)
# {fusen} steps
fill_description(pkg = dummypackage_fixed, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_flat_template(pkg = dummypackage_fixed, overwrite = TRUE, open = FALSE))
flat_file <- dev_file[grepl("flat_", dev_file)]
# Inflate once
usethis::with_project(dummypackage_fixed, {
  suppressMessages(
    inflate(
      pkg = dummypackage_fixed, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )
})
# Add a not registered file to the package
cat("# test R file\n", file = file.path(dummypackage_fixed, "R", "to_keep.R"))


test_that("register_all_to_config can be run twice", {
  expect_true(inherits(register_all_to_config, "function"))

  usethis::with_project(dummypackage_fixed, {
    expect_error(
      out_path <- register_all_to_config(dummypackage_fixed),
      regexp = NA
    )
    expect_equal(out_path, file.path("dev", "config_fusen.yaml"))

    # What happens if everything is already registered? ----
    expect_message(
      out_path <- register_all_to_config(dummypackage_fixed),
      regexp = "There is no file to register"
    )

    expect_equal(out_path, file.path("dev", "config_fusen.yaml"))

    # Add a new file to register from a new flat file ----
    add_flat_template(template = "add", flat_name = "new_one", open = FALSE)
    # Without vignette first
    suppressMessages(
      inflate(
        pkg = dummypackage_fixed,
        flat_file = "dev/flat_new_one.Rmd", vignette_name = NA,
        check = FALSE, open_vignette = FALSE
      )
    )

    expect_error(
      out_path <- register_all_to_config(dummypackage_fixed),
      regexp = NA
    )

    # With vignette then
    suppressMessages(
      inflate(
        pkg = dummypackage_fixed,
        flat_file = "dev/flat_new_one.Rmd",
        vignette_name = "new_one",
        check = FALSE, open_vignette = FALSE
      )
    )

    expect_error(
      out_path <- register_all_to_config(dummypackage_fixed),
      regexp = NA
    )
  })
})

test_that("config file is correctly built after half register", {
  out_actual <- yaml::read_yaml(file.path(dummypackage_fixed, "dev", "config_fusen.yaml"))
  # To update
  # file.copy(file.path(dummypackage_fixed, "dev", "config_fusen.yaml"), here::here("tests/testthat/config_fusen_register.yaml"), overwrite = TRUE)
  if (file.exists("config_fusen_register.yaml")) {
    out_expected <- yaml::read_yaml("config_fusen_register.yaml")
  } else {
    # during dev in root directory
    out_expected <- yaml::read_yaml(here::here("tests/testthat/config_fusen_register.yaml"))
  }

  expect_equal(out_actual, out_expected)
})

unlink(dummypackage, recursive = TRUE)

# register_all_to_config runs properly after check_not_registered ----

dummypackage <- tempfile("register")
dir.create(dummypackage)
# unlink(dummypackage, recursive = TRUE)
# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_flat_template(pkg = dummypackage, overwrite = TRUE, open = FALSE))
flat_file <- dev_file[grepl("flat_", dev_file)]
# Inflate once
usethis::with_project(dummypackage, {
  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )

  # Add a not registered file to the package
  cat("# test R file\n", file = file.path(dummypackage, "R", "to_keep.R"))

  test_that("register_all_to_config runs properly after check_not_registered", {
    suppressMessages(check_not_registered_files(open = FALSE))
    # expect csv contains : No existing source path found
    not_registered <- "dev/config_not_registered.csv"

    not_registered_content <- read.csv(not_registered, stringsAsFactors = FALSE)
    expected_registered <- structure(
      list(
        type = "R",
        path = "R/to_keep.R",
        origin = "No existing source path found."
      ),
      class = "data.frame",
      row.names = c(NA, -1L)
    )
    expect_equal(not_registered_content, expected_registered)
    suppressMessages(register_all_to_config())
    # expect deleted config_not_registered.csv
    expect_false(file.exists(not_registered))
    # expect cnofig file with "keep" section
    config_file <- yaml::read_yaml("dev/config_fusen.yaml")
    expect_equal(config_file[["keep"]][["R"]], "R/to_keep.R")
    # Create an obsolete file
    file.copy("R/my_median.R", "R/my_old_fun.R")
    expect_message(check_not_registered_files(open = FALSE), "Some files in your package are not registered")
    # expect csv contains : Possibly deprecated file issued from flat...
    not_registered_content <- read.csv(not_registered, stringsAsFactors = FALSE)
    expected_registered <- structure(
      list(
        type = "R",
        path = "R/my_old_fun.R",
        origin = "Possibly deprecated file. Please check its link with detected flat source: dev/flat_full.Rmd"
      ),
      class = "data.frame",
      row.names = c(NA, -1L)
    )

    expect_equal(not_registered_content, expected_registered)
  })

  test_that("register_all_to_config can append new files in keep section", {
    suppressMessages(register_all_to_config())
    config_file <- yaml::read_yaml("dev/config_fusen.yaml")
    expect_equal(
      sort(config_file[["keep"]][["R"]]),
      sort(c("R/to_keep.R", "R/my_old_fun.R"))
    )
    # expect config file with my_old_fun.R in "keep" section
    file.remove("R/my_old_fun.R")
    expect_message(check_not_registered_files(open = FALSE),
      regexp = "There are no unregistered files"
    )

    # register_all_to_config throws an error if there is something to add to the config
    file.copy("R/my_median.R", "R/my_second_old_fun.R")
    config_file <- yaml::read_yaml("dev/config_fusen.yaml")
    expect_error(
      register_all_to_config(),
      regexp = "Some paths in config_file do not exist: R/my_old_fun.R"
    )

    # Clean the missing file and it should be good to add the second new file
    config_file <- yaml::read_yaml("dev/config_fusen.yaml")
    config_file$keep$R <- "R/to_keep.R"
    write_yaml_verbatim(config_file, "dev/config_fusen.yaml")

    expect_message(register_all_to_config(),
      regexp = "R: R/my_second_old_fun.R was added to the config file"
    )
    config_file <- yaml::read_yaml("dev/config_fusen.yaml")
    expect_equal(
      sort(config_file[["keep"]][["R"]]),
      sort(c("R/to_keep.R", "R/my_second_old_fun.R"))
    )

    # add new file to add to keep
    cat("new_to_keep\n", file = "R/newfile_to_keep.R")
    expect_message(register_all_to_config(),
      regexp = "R: R/newfile_to_keep.R was added to the config file"
    )
    config_file <- yaml::read_yaml("dev/config_fusen.yaml")
    expect_equal(
      sort(config_file[["keep"]][["R"]]),
      sort(c("R/to_keep.R", "R/my_second_old_fun.R", "R/newfile_to_keep.R"))
    )
  })
})
unlink(dummypackage, recursive = TRUE)

# Test df_to_config with custom config file path ----
config_file_path <- tempfile(fileext = ".yaml")

test_that("df_to_config fails when appropriate", {
  withr::with_options(list(fusen.config_file = config_file_path), {
    all_files <- tibble::tribble(
      ~type, ~files,
      "R", "zaza.R",
      "R", "zozo.R",
      "test", "test-zaza.R"
    )

    expect_error(
      df_to_config(all_files),
      "df_files should contains two columns named: 'type' and 'path'"
    )

    all_files <- tibble::tribble(
      ~type, ~path,
      "R", "zaza.R",
      "R", "zozo.R",
      "test", "test-zaza.R"
    )

    expect_error(
      df_to_config(all_files),
      "Some 'path' in df_files do not exist: row 1- R: zaza.R, row 2- R: zozo.R, row 3- test: test-zaza.R"
    )

    expect_error(
      config_file_out <- df_to_config(all_files, force = TRUE),
      regexp = NA
    )

    expect_equal(config_file_out, config_file_path)
    all_keep <- yaml::read_yaml(config_file_out)
    expect_equal(names(all_keep), "keep")
    expect_equal(names(all_keep$keep), c("path", "state", "R", "tests", "vignettes"))
    expect_equal(all_keep$keep$path, c("keep"))
    expect_equal(all_keep$keep$state, c("active"))
    expect_equal(all_keep$keep$R, c("zaza.R", "zozo.R"))
    expect_equal(all_keep$keep$tests, c("test-zaza.R"))
    expect_equal(all_keep$keep$vignettes, list())
  })
})
file.remove(config_file_path)

# Create files, even empty
dir_tmp <- tempfile()
dir.create(dir_tmp)
file.create(file.path(dir_tmp, c("zaza.R", "zozo.R", "test-zaza.R", "toto.Rmd")))
config_file_path <- tempfile(fileext = ".yaml")

test_that("df_to_config works", {
  withr::with_dir(dir_tmp, {
    withr::with_options(list(fusen.config_file = config_file_path), {
      # Use full path

      all_files <- tibble::tribble(
        ~type, ~path,
        "R", "zaza.R",
        "R", "zozo.R",
        "test", "test-zaza.R"
      )

      expect_message(config_file_out <- df_to_config(all_files),
        regexp = "R: zaza.R was added to the config file"
      )
    })

    expect_equal(config_file_out, config_file_path)
    all_keep <- yaml::read_yaml(config_file_out)
    expect_equal(names(all_keep), "keep")
    expect_equal(names(all_keep$keep), c("path", "state", "R", "tests", "vignettes"))
    expect_equal(all_keep$keep$path, c("keep"))
    expect_equal(all_keep$keep$state, c("active"))
    expect_equal(all_keep$keep$R, c("zaza.R", "zozo.R"))
    expect_equal(all_keep$keep$tests, c("test-zaza.R"))
    expect_equal(all_keep$keep$vignettes, list())
  })
})

# Second pass
all_files <- tibble::tribble(
  ~type, ~path,
  "r", "tata.R",
  "R", "toto.R",
  "tests", "test-tata.R",
  "vignettes", "tata_vignette.Rmd"
)

file.create(file.path(dir_tmp, c("tata.R", "toto.R", "test-tata.R", "tata_vignette.Rmd")))

test_that("df_to_config works after 2nd run", {
  withr::with_dir(dir_tmp, {
    withr::with_options(list(fusen.config_file = config_file_path), {
      expect_message(
        config_file <- df_to_config(all_files),
        regexp = "Some files group already existed and were overwritten: keep"
      ) # "keep" is default
    })
  })
})

unlink(dir_tmp, recursive = TRUE)
file.remove(config_file_path)

# Create files, even empty ----
dir_tmp <- tempfile()
dir.create(dir_tmp)
file.create(file.path(dir_tmp, c("zaza.R", "zozo.R", "test-zaza.R")))
dir.create(file.path(dir_tmp, "vignettes"))
file.create(file.path(dir_tmp, "vignettes", "my-vignette.Rmd"))
config_file_path <- tempfile(fileext = ".yaml")

test_that("df_to_config works with files having no content", {
  withr::with_options(list(fusen.config_file = config_file_path), {
    withr::with_dir(dir_tmp, {
      # Use relative path
      all_files <- tibble::tribble(
        ~type, ~path,
        "R", "zaza.R",
        "R", "zozo.R",
        "test", "test-zaza.R",
        "vignette", file.path("vignettes", "my-vignette.Rmd")
      )

      expect_message(config_file_out <- df_to_config(all_files),
        regexp = "vignettes: vignettes/my-vignette.Rmd was added to the config file"
      )
    })

    expect_equal(config_file_out, config_file_path)
    all_keep <- yaml::read_yaml(config_file_out)
    expect_equal(names(all_keep), "keep")
    expect_equal(names(all_keep$keep), c("path", "state", "R", "tests", "vignettes"))
    expect_equal(all_keep$keep$path, c("keep"))
    expect_equal(all_keep$keep$state, c("active"))
    # Relative path
    expect_equal(all_keep$keep$R, c("zaza.R", "zozo.R"))
    expect_equal(all_keep$keep$tests, c("test-zaza.R"))
    expect_equal(all_keep$keep$vignettes, c("vignettes/my-vignette.Rmd"))
  })
})

# Remove one file to see if it is detected ----
file.remove(file.path(dir_tmp, c("zaza.R")))
test_that("df_to_config works with files having no content", {
  withr::with_options(list(fusen.config_file = config_file_path), {
    withr::with_dir(dir_tmp, {
      # Use relative path
      all_files <- tibble::tribble(
        ~type, ~path,
        "R", "zaza.R",
        "R", "zozo.R",
        "test", "test-zaza.R",
        "vignette", file.path("vignettes", "my-vignette.Rmd")
      )

      expect_error(config_file_out <- df_to_config(all_files),
        regexp = "zaza.R"
      )
    })
  })
})

unlink(dir_tmp, recursive = TRUE)
file.remove(config_file_path)

# Test df_to_config with inflate parameters and flat_file_path = "keep"
config_file_path <- tempfile(fileext = ".yaml")
dir_tmp <- tempfile()
dir.create(dir_tmp)
file.create(file.path(dir_tmp, c("zaza.R", "zozo.R", "test-zaza.R")))

test_that("df_to_config does not work with inflate_parameters and flat_file_path = \"keep\"", {
  withr::with_dir(dir_tmp, {
    withr::with_options(list(fusen.config_file = config_file_path), {
      all_files <- tibble::tribble(
        ~type, ~path,
        "R", "zaza.R",
        "R", "zozo.R",
        "test", "test-zaza.R"
      )

      expect_error(
        df_to_config(all_files,
          inflate_parameters = list(
            flat_file = "dev/my_flat.Rmd",
            vignette_name = "My new vignette",
            open_vignette = FALSE,
            check = FALSE,
            document = TRUE,
            overwrite = "yes"
          )
        )
      )
    })
  })
})

unlink(dir_tmp, recursive = TRUE)

# df to config with inflate_parameters
# unlink(dummypackage, recursive = TRUE)
dummypackage <- tempfile("dftoconfig")
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- (add_minimal_package(pkg = dummypackage, overwrite = TRUE, open = FALSE))
# let's create a flat file
flat_file <- dev_file[grepl("flat_", dev_file)]

dir.create(file.path(dummypackage, "R"))
file.create(file.path(dummypackage, "R", "my_fun.R"))

dir.create(file.path(dummypackage, "tests"))
dir.create(file.path(dummypackage, "tests/testthat"))
file.create(file.path(dummypackage, "tests/testthat", "test-my_fun.R"))

dir.create(file.path(dummypackage, "vignettes"))
file.create(file.path(dummypackage, "vignettes", "minimal.Rmd"))

test_that("df_to_config works with inflate parameters", {
  usethis::with_project(dummypackage, {
    all_files <- structure(list(
      type = c("R", "test", "vignette"),
      path = c(
        file.path(dummypackage, "R", "my_fun.R"),
        file.path(dummypackage, "tests/testthat", "test-my_fun.R"),
        "vignettes/minimal.Rmd"
      )
    ), row.names = c(NA, -3L), class = c("tbl_df", "tbl", "data.frame"))

    relative_flat_file <- "dev/flat_minimal.Rmd"

    config_file <- df_to_config(
      df_files = all_files,
      flat_file_path = relative_flat_file,
      clean = TRUE,
      state = "active",
      force = TRUE,
      inflate_parameters = list(
        flat_file = "dev/flat_minimal.Rmd",
        vignette_name = "My new vignette",
        open_vignette = FALSE,
        check = FALSE,
        document = TRUE,
        overwrite = "yes"
      )
    )

    config_file_content <- yaml::read_yaml(config_file)

    expect_equal(
      config_file_content[[basename(flat_file)]][["inflate"]],
      list(
        flat_file = "dev/flat_minimal.Rmd",
        vignette_name = "My new vignette",
        open_vignette = FALSE,
        check = FALSE,
        document = TRUE,
        overwrite = "yes"
      )
    )
  })
})
unlink(dummypackage, recursive = TRUE)

# Verify df_to_config was run during ìnflate()
dummypackage <- tempfile("clean")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_flat_template(pkg = dummypackage, overwrite = TRUE, open = FALSE))
flat_file <- dev_file[grepl("flat_", dev_file)]

test_that("inflate parameters are put into config_fusen.yaml", {
  # Inflate once
  usethis::with_project(dummypackage, {
    suppressMessages(
      inflate(
        pkg = dummypackage, flat_file = flat_file,
        vignette_name = "Get started", check = FALSE,
        open_vignette = FALSE,
        extra_param = "toto"
      )
    )

    config_yml <- yaml::read_yaml(file.path(dummypackage, "dev/config_fusen.yaml"))

    expect_equal(
      config_yml[[basename(flat_file)]][["inflate"]][["vignette_name"]],
      "Get started"
    )

    expect_false(
      config_yml[[basename(flat_file)]][["inflate"]][["check"]]
    )

    expect_false(
      config_yml[[basename(flat_file)]][["inflate"]][["open_vignette"]]
    )

    expect_true(
      config_yml[[basename(flat_file)]][["inflate"]][["document"]]
    )

    expect_equal(
      config_yml[[basename(flat_file)]][["inflate"]][["overwrite"]],
      "ask"
    )


    expect_equal(
      config_yml[[basename(flat_file)]][["inflate"]][["extra_param"]],
      "toto"
    )

    # Let's inflate a second time with different parameters

    suppressMessages(
      inflate(
        pkg = dummypackage, flat_file = flat_file,
        vignette_name = "Get started again", check = FALSE,
        open_vignette = FALSE, overwrite = "yes",
        extra_param = "tutu", document = FALSE
      )
    )

    config_yml <- yaml::read_yaml(file.path(dummypackage, "dev/config_fusen.yaml"))

    expect_equal(
      config_yml[[basename(flat_file)]][["inflate"]][["vignette_name"]],
      "Get started again"
    )

    expect_false(
      config_yml[[basename(flat_file)]][["inflate"]][["check"]]
    )

    expect_false(
      config_yml[[basename(flat_file)]][["inflate"]][["open_vignette"]]
    )

    expect_false(
      config_yml[[basename(flat_file)]][["inflate"]][["document"]]
    )

    expect_equal(
      config_yml[[basename(flat_file)]][["inflate"]][["overwrite"]],
      "yes"
    )


    expect_equal(
      config_yml[[basename(flat_file)]][["inflate"]][["extra_param"]],
      "tutu"
    )
  })
})

unlink(dummypackage, recursive = TRUE)
# rstudioapi::navigateToFile(config_file)
