% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinctiveness_global.R
\name{distinctiveness_global}
\alias{distinctiveness_global}
\title{Global/Regional Functional Distinctiveness from dissimilarity matrix}
\usage{
distinctiveness_global(dist_obj, di_name = "global_di")
}
\arguments{
\item{dist_obj}{a functional distance matrix as given by
\code{compute_dist_matrix()}, with species name as row and column names \strong{or}
a \code{dist()} object with species names as \code{labels()}}

\item{di_name}{a character vector giving the name of the distinctiveness
column in the final data.frame (\strong{default}: \code{global_di})}
}
\value{
a data.frame with two columns: by default \code{species} that contains the
species names and \code{global_di} that contains the distinctiveness values.
The first column that contains species names can renamed based on \code{dist_obj}
\code{dimnames}, while the second column is renamed through the \code{di_name}
argument.`
}
\description{
Given a distance (or dissimilarity) matrix or \code{dist()} objects compute
regional/global level distinctiveness as if all species were present in the
same community.
}
\seealso{
\code{vignette("rarity_indices", package = "funrar")} and
\code{\link[=distinctiveness]{distinctiveness()}} Details section for detail on the index
}
