% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scarcity.R
\name{scarcity_stack}
\alias{scarcity_stack}
\alias{scarcity_tidy}
\title{Scarcity}
\usage{
scarcity_stack(com_df, sp_col, com, abund)

scarcity_tidy(com_df, sp_col, com, abund)
}
\arguments{
\item{com_df}{a stacked (= tidy) data.frame from a single community with each
row representing a species in a community}

\item{sp_col}{a character vector, the name of the species column in \code{com_df}}

\item{com}{a character vector indicating the column name of communities ID in
\code{com_df}}

\item{abund}{a character vector, the name of the column containing relative
abundances values}
}
\value{
The same table as \code{com_df} with an added \eqn{S_i} column
for Scarcity values.
}
\description{
Compute scarcity values for several communities. Scarcity computation
requires relative abundances. Scarcity is close to 1 when a species is rare
in a community and close to 0 when it is abundant. See \code{\link[=scarcity]{scarcity()}} function
or the functional rarity indices vignette included in the package (type
\code{vignette("rarity_indices", package = "funrar")}) for details about the
index. You can either use \verb{_stack()} or \verb{_tidy()} functions as they are
aliases of one another.
}
\examples{
data("aravo", package = "ade4")

# Site-species matrix converted into data.frame
mat = as.matrix(aravo$spe)
mat = make_relative(mat)
dat = matrix_to_stack(mat, "value", "site", "species")
dat$site = as.character(dat$site)
dat$species = as.character(dat$species)

si_df = scarcity_stack(dat, "species", "site", "value")
head(si_df)

}
\seealso{
\code{\link[=scarcity]{scarcity()}} and \code{vignette("rarity_indices", package = "funrar")}
for details on the scarcity metric; \code{\link[=distinctiveness_stack]{distinctiveness_stack()}},
\code{\link[=restrictedness_stack]{restrictedness_stack()}}, \code{\link[=uniqueness_stack]{uniqueness_stack()}}
}
