% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funmediation.r
\name{funmediation}
\alias{funmediation}
\title{funmediation:  Fit funmediation model}
\usage{
funmediation(
  data,
  treatment,
  mediator,
  outcome,
  id,
  time,
  tve_covariates_on_mediator = NULL,
  tie_covariates_on_mediator = NULL,
  covariates_on_outcome = NULL,
  interpolate = TRUE,
  tvem_penalize = TRUE,
  tvem_penalty_order = 1,
  tvem_spline_order = 3,
  tvem_num_knots = 3,
  tvem_do_loop = FALSE,
  tvem_use_bic = FALSE,
  binary_mediator = FALSE,
  binary_outcome = FALSE,
  nboot = 200,
  boot_level = 0.05,
  show_progress = FALSE
)
}
\arguments{
\item{data}{The dataset containing the data to be analyzed, in long
format (one row per observation, multiple per individual).}

\item{treatment}{The name of the variable containing the treatment
assignment, assumed to be unidimensional (either binary
or else numeric).  We recommend a binary (dichotomous) treatment with
0 for control and 1 for experimental).  The values of this variable
should be the same for each row for a given subject.  If there are
more than one treatment variables, such as a dummy-coded exposure with
more than two levels, specify them as a formula such as ~x1+x2.}

\item{mediator}{The name of the mediator variable. The values of
this variable can (and should) vary within each subject.}

\item{outcome}{The name of the outcome variable. The values of this
variable should be the same for each row for a given subject.}

\item{id}{The name of the variable identifying each subject.}

\item{time}{The name of the time variable.}

\item{tve_covariates_on_mediator}{The covariates with time-varying-effects,
if any, to be included in the model predicting the mediator from
the treatment.}

\item{tie_covariates_on_mediator}{The covariates with time-invariant
effects, if any, to be included in the
model predicting the mediator from the treatment.}

\item{covariates_on_outcome}{The covariates, if any, to be included
in the model predicting the outcome from the treatment.
They are assumed to be subject-level (time-invariant both in value
and in effect).}

\item{interpolate}{What kind of presmoothing to use in the
penalized functional regression -- specifically, whether
to interpolate each subject's trajectory on the mediator
(TRUE) or fit a spline to each subject's trajectory on the
mediator (FALSE).  This will be counted as TRUE if
binary_mediator is TRUE because it does
not make as much sense to interpolate a binary outcome.}

\item{tvem_penalize}{Input to be passed on to the tvem function}

\item{tvem_penalty_order}{Input to be passed on to the tvem function}

\item{tvem_spline_order}{Input to be passed on to the tvem function}

\item{tvem_num_knots}{If tvem_do_loop is FALSE, then tvem_num_knots
is passed on to the tvem function as num_knots, an integer representing
the number of interior knots per B-spline. If tvem_do_loop is
TRUE then tvem_num_knots is reinterpreted as the highest number of
interior knots to try.}

\item{tvem_do_loop}{Whether to use a loop to select the number of knots
with a pseudo-AIC or pseudo-BIC, passed on to the tvem function}

\item{tvem_use_bic}{This parameter only matters if tvem_do_loop is TRUE.
If tvem_do_loop is TRUE
and tvem_use_bic is TRUE, then the information criterion used will be
a pseudolikelihood version of BIC.
If tvem_do_loop is TRUE and tvem_use_bic is FALSE, then the information
criterion used will be
a pseudolikelihood version of AIC instead. If tvem_do_loop is FALSE then
tvem_use_bic is ignored.}

\item{binary_mediator}{Whether the mediator should be modeled as
dichotomous with a logistic model (TRUE),
or numerical with a normal model (FALSE).}

\item{binary_outcome}{Whether the outcome should be modeled as
dichotomous with a logistic model (TRUE),
or numerical with a normal model (FALSE).}

\item{nboot}{Number of bootstrap samples for bootstrap significance
test of the overall effect. This test is done using the boot
function from the boot package by Angelo Canty and Brian Ripley.
It differs somewhat from the bootstrap approach used in a similar
context by Lindquist (2012).  We recommend using at least 200 bootstrap
samples and preferably 500 or more.}

\item{boot_level}{One minus the nominal coverage for
the bootstrap confidence interval estimates.}

\item{show_progress}{Whether to display intermediate updates on the progress of
the bootstrap simulations.  If show_progress==FALSE then the funmediation
function runs silently but results can be viewed via the print and plot methods.
If show_progress==TRUE then progress messages will be printed.}
}
\value{
An object of type funmediation. The components of an object of
type funmediation are as follows:
\describe{
\item{original_results}{The estimates from the fitted models for
predicting the mediator from the treatment, predicting the outcome
from the mediator and treatment, and predicting the outcome from the
treatment alone.}
\item{bootstrap_results}{The estimate and confidence interval of the
indirect effect using a bootstrap approach.}
}

The original_results component has these components within it:
\describe{
\item{time_grid}{Grid of time points on which the functional
coefficients are estimated.}
\item{alpha_int_estimate}{Estimated intercept function (as a vector
 of estimates) from the TVEM regression of the mediator, M, on treatment, X.}
\item{alpha_int_se}{Estimated pointwise standard errors associated
with the above.}
\item{alpha_X_estimate}{Estimated time-varying treatment effect
from the TVEM regression of the mediator, M, on the treatment, X.}
\item{alpha_X_se}{Estimated pointwise standard errors associated
with the above.}
\item{beta_int_estimate}{Estimated scalar intercept from the scalar-on-
function regression of the outcome, Y, on the mediator, M, and treatment, X.}
\item{beta_int_se}{Estimated standard error for the above.}
\item{beta_X_estimate}{Estimated scalar coefficient for the treatment, X,
from the scalar-on-function regression of the outcome, Y, on the mediator,
M, and treatment, X.}
\item{beta_X_se}{Estimated standard error for the above.}
\item{beta_M_estimate}{Estimated functional coefficient for the mediator,
 M, from the scalar-on-function regression of the outcome, Y, on the mediator,
 M, and treatment, X.}
\item{beta_M_se}{Estimated pointwise standard errors associated with the above}
\item{beta_M_pvalue}{The p-value for significance of the mediator, M, in
predicting outcome, Y, after adjusting for treatment, X.}
\item{tau_int_estimate}{Intercept from simple model predicting outcome, Y,
directly from treatment, X.}
\item{tau_int_se}{Estimated standard error for the above.}
\item{tau_X_estimate}{Coefficient for treatment in model predicting outcome,
Y, directly from treatment, X.}
\item{tau_X_se}{Estimated standard error for the above.}
\item{indirect_effect_estimate}{Estimated indirect effect, calculated as
the dot product of the effect of treatment on mediator and the treatment-
adjusted effect of mediator on outcome.  It is a scalar, even though the
two component effects are functions of time.}
\item{tvem_XM_details}{Detailed output from the tvem function for the time-
varying-effect model predicting the mediator, M, from the treatment, X.}
\item{funreg_MY_details}{Detailed output from the refund::pfr function for
the scalar-on-function functional regression predicting the outcome, Y, from
the treatment, X, and mediator, M.}
\item{total_effect_details}{Detailed output from the linear or generalized
linear model predicting the outcome from the treatment alone, ignoring the
mediator (i.e., total effect)}
}

The bootstrap_results component has these components within it:
\describe{
\item{indirect_effect_boot_estimate}{Bootstrap point estimate of the
indirect effect (average of bootstrap sample estimates).}
\item{indirect_effect_boot_se}{Bootstrap standard error for the
indirect effect (standard deviation of bootstrap sample estimates).}
\item{indirect_effect_boot_norm_lower}{Lower end of the bootstrap
confidence interval using the normal method in boot.ci in the boot package.}
\item{indirect_effect_boot_norm_upper}{Upper end of the bootstrap
confidence interval using the normal method.}
\item{indirect_effect_boot_basic_lower}{Lower end of the bootstrap
confidence interval using the basic method in boot.ci in the boot package.}
\item{indirect_effect_boot_basic_upper}{Upper end of the bootstrap
confidence interval using the basic method.}
\item{indirect_effect_boot_perc_lower}{Lower end of the bootstrap
confidence interval using the percentile method in boot.ci in the boot package.}
\item{indirect_effect_boot_perc_upper}{Upper end of the bootstrap
confidence interval using the percentile method.}
\item{boot_level}{The alpha level used for the bootstrap confidence interval.}
\item{boot1}{The output returned from the boot function.}
\item{time.required}{The amount of time spent doing the bootstrap test,
including generating and analyzing all samples.}
}
}
\description{
Calculate indirect effect of a binary treatment on a scalar
response as mediated by a longitudinal functional trajectory
(see Baron & Kenny, 1986; Lindquist, 2012; Coffman et al., 2021).
}
\note{
This function calls the tvem function in the tvem package.
It also calls the pfr function in the refund package (see
Goldsmith et al., 2011) to perform penalized functional regression.
Some suggestions on interpreting the output from penalized functional
regression are given by Dziak et al. (2019).
}
\references{
Baron, R.M., & Kenny, D.A. (1986). The moderator-mediator variable
distinction in social psychological research: Conceptual, strategic,
and statistical considerations. Journal of Personality & Social
Psychology, 51: 1173-1182.

Coffman, D. L., Dziak, J. J., Litson, K., Chakraborti, Y., Piper, M. E., & Li, R. #' (2021). A causal approach to functional mediation analysis with application to a
smoking cessation intervention. <arXiv:2112.03960>

Dziak, J. J., Coffman, D. L., Reimherr, M., Petrovich, J., Li, R.,
Shiffman, S., & Shiyko, M. P. (2019). Scalar-on-function regression
for predicting distal outcomes from intensively gathered longitudinal
data: interpretability for applied scientists.
Statistics Surveys, 13, 150-180. <doi:10.1214/19-SS126>

Goldsmith, J., Bobb, J., Crainiceanu, C., Caffo, B., & Reich, D.
(2011). Penalized functional regression. Journal of Computational
and Graphical Statistics, 20(4), 830-851. <doi:10.1198/jcgs.2010.10007>

Lindquist, M. A. (2012). Functional Causal Mediation Analysis
With an Application to Brain Connectivity. Journal of the American
Statistical Association, 107: 1297-1309. <doi:10.1080/01621459.2012.695640>
}
