% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.faMain.R
\name{summary.faMain}
\alias{summary.faMain}
\title{Summary Method for an Object of Class faMain}
\usage{
\method{summary}{faMain}(object, digits = 2, Set = 1,
  HPthreshold = 0.05, PrintLevel = 1, DiagnosticsLevel = 1,
  itemSort = FALSE, ...)
}
\arguments{
\item{object}{(Object of class \code{\link{faMain}}) The returned object 
from a call to \strong{faMain}.}

\item{digits}{(Integer) Print output with user-specified number of significant digits. 
Default \code{digits = 2}.}

\item{Set}{The argument \code{Set} can be specified as either an integer 
  value (i.e., 1 through the number of unique solution sets) or a character 
  value (i.e., 'UnSpun'). 
\itemize{
  \item{\strong{Integer}} Summarize the solution from the specified 
  solution set. If \code{Set = 1}, the "global minimum" solution is 
  reported. See \code{\link{faMain}} for more details about finding 
  the "global" and local minima. 
  \item{\strong{'UnSpun'}} Summarize the solution from the rotated 
  output that was produced by rotating from the unrotated (i.e., unspun) 
  factor orientation. All other solutions are rotated from a randomly 'spun' rotation 
  (i.e., by orientating the unrotated factor solution via a random orthonormal 
  matrix) . 
 }}

\item{HPthreshold}{(Numeric) User-defined threshold for declaring that the 
absolute value of a factor pattern coefficient is in a hyperplane. The hyperplane count is the number of 
near-zero (as defined by HPthreshold; see Cattell, 1978, p. 105) elements in the factor pattern matrix. 
Default \code{HPthreshold = .05}.}

\item{PrintLevel}{(Integer) Controls the level of printing. If \code{PrintLevel = 0} then no output is printed. 
If \code{PrintLevel = 1} then the standard output 
will be printed. If \code{PrintLevel = 2} more extensive output (e.g., the Factor Structure Matrix) will 
be printed. Default \code{PrintLevel = 1}.}

\item{DiagnosticsLevel}{(Integer) Controls the amount of diagnostics information that is computed on the 
rotation local minima. If \code{DiagnosticsLevel = 1} then only the number 
of local solution sets will be reported. If \code{DiagnosticsLevel = 2} then
the program will determine whether all solutions within a solution set are identicial.
Default \code{DiagnosticsLevel = 1}.}

\item{itemSort}{(Logical) If TRUE, sort the order of the observed variables to produce
a "staircase"-like pattern. Note that this argument cannot handle bifactor models at this time.
Defaults to \code{itemSort} = FALSE.}

\item{\dots}{Additional arguments affecting the summary produced.}
}
\value{
\itemize{
    \item \code{loadings} (Matrix) Factor loadings for the solution associated with the 
                   minimum (maximum) rotation complexity value (default) or the user-chosen solution.
     \item \code{Phi} (Matrix) Factor correlation matrix for the solution associated with the 
                   minimum (maximum) rotation complexity value (default) or the user-chosen solution.
     \item \code{FS} (Matrix) Factor structure matrix  for the solution associated with the 
                   minimum (maximum) rotation complexity value (default) or the user-chosen solution.
     \item \code{Set} (Integer) The returned Set number. 
     \item \code{h2} (Matrix) Communalities for the returned factor solution. If \code{Boostrap = TRUE} then
     \code{h2} also returns the bootstrap standard errors and associated confidence bounds from 
               the boostrap distribution.
     \item{facIndeterminacy}{Matrix} Factor Indeterminacy values. If \code{Boostrap = TRUE} then
        \code{facIndeterminacy} also returns the bootstrap standard errors and associated confidence bounds from 
               the boostrap distribution.          
     \item \code{SetComplexityValues} (vector) Rotation complexity value for each solution set. 
     \item \code{HP_counts} (vector) Hyperplane count for each solution set.  
     \item \code{MaxWithinSetRMSD} (vector) If \code{DiagnosticsLevel = 2} the the program will compute
     within set RMSD values.  These values represent the root mean squared deviations of each 
     within set solution with the first solution in a set. If the \code{MaxWithinSetRMSD = 0} 
     for a set, then all within set solutions are identical. If  \code{MaxWithinSetRMSD > 0} 
     then at least one solution differs from the remaining solutions within a set (i.e., two solutions 
     with different factor loadings produced identical complexity values). 
     \item \code{RMSD} (Numeric) The root mean squared deviation between the 
          observed and model-implied correlation matrix.
     \item \code{RMSD} (Numeric) The root mean squared absolute deviation between the 
          observed and model-implied correlation matrix. 
     \item \code{NumberLocalSolutions} (Integer) The number of local solution sets.     
     \item \code{LocalSolutions} (List) A list of local solutions (factor loadings, factor correlations, etc). 
     \item\code{rotate} Designates which rotation method was applied.
   }
}
\description{
This function summarizes results from a call to \strong{faMain}.
}
\details{
\strong{summary.faMain} provides various criteria for judging the adequacy of 
the rotated factor solution(s). After reporting the number of solution sets.
(i.e., rotated solutions with the same complexity value) the following measures 
  of factor adequacy are reported for each solution set:
\itemize{
 \item \strong{Complexity Value}: The rotation complexity value (see \code{\link{faMain}} for details).
 \item \strong{Hyperplane Count}: The number of near-zero loadings (defined by \strong{HPthreshold}) 
   for all factor patterns in a solution set (if \strong{MaxWithinSetRMSD > 0} then Hyperplane Count refers to 
 the first factor pattern in the solution set). 
 \item \strong{\% Cases (x 100) in Set}: The percentage of factor patterns in each solution set.
 \item \strong{RMSD}: The root mean squared deviation between the first factor pattern 
   in each solution set with the first factor pattern  in the solution set specified by the \strong{Set} parameter. By default, \strong{Set = 1}.
 \item \strong{MaxWithinSetRMSD}: The maximum root mean squared deviation between all within set solutions and 
 the first element in the solution set. When \strong{MaxWithinSetRMSD > 0} then the solution 
 set contains non-identical rotated factor patterns with identical complexity values. 
 \item \strong{Converged}: A Logical (TRUE/FALSE) that  indicates whether all within set rotations converged.
 }
  Note that  the printed factor pattern is not sorted even if \strong{itemSort} 
 is requested in \link{faMain}.
}
\examples{
## Load Thurstone's Box data from the fungible library
library(fungible)
data(Box26)

## Create a matrix from Thurstone's solution
## Used as a target matrix to sort columns of the estimated solution
ThurstoneSolution <- matrix(c(   .95,  .01,  .01,
                                 .02,  .92,  .01,
                                 .02,  .05,  .91,
                                 .59,  .64, -.03,
                                 .60,  .00,  .62,
                                -.04,  .60,  .58,
                                 .81,  .38,  .01,
                                 .35,  .79,  .01,
                                 .79, -.01,  .41,
                                 .40, -.02,  .79,
                                -.04,  .74,  .40,
                                -.02,  .41,  .74,
                                 .74, -.77,  .06,
                                -.74,  .77, -.06,
                                 .74,  .02, -.73,
                                -.74, -.02,  .73,
                                -.07,  .80, -.76,
                                 .07, -.80,  .76,
                                 .51,  .70, -.03,
                                 .56, -.04,  .69,
                                -.02,  .60,  .58,
                                 .50,  .69, -.03,
                                 .52, -.01,  .68,
                                -.01,  .60,  .55,
                                 .43,  .46,  .45,
                                 .31,  .51,  .46), nrow = 26, ncol = 3,
                                                            byrow=TRUE)
## Example 1: Multiple solution sets.
## Ignore warnings about non-positive definite sample correlation matrix
suppressWarnings(
  fout <- faMain(R             = Box26,
                 numFactors    = 3,
                 facMethod     = 'faregLS',
                 rotate        = 'infomaxQ',
                 targetMatrix  = ThurstoneSolution,
                 rotateControl = 
                   list(numberStarts = 25, ## increase in real problem
                        standardize  = 'none'),
                 Seed          = 123)
)

## Summarize the factor analytic output                                     
summary(object           = fout, 
        digits           = 2,
        Set              = 2, 
        HPthreshold      = .10,
        PrintLevel       = 1,
        DiagnosticsLevel = 2)
          
     
## Example 2: Bootstrap Illustration 
## Step 1: In an initial analysis, confirm that all rotations converge
  ## to a single minimum complexity value.
## Step 2: If Step 1 is satisfied then generate bootstrap samples.

## Load Amazon box data             
data("AmzBoxes")

## Convert box dimensions into Thurstone's indicators
BoxData <- 
  GenerateBoxData(AmzBoxes[, 2:4],          ## Select columns 2, 3, & 4
                  BoxStudy         = 26,    ## 26 indicators
                  Reliability      = 0.75,  ## Add unreliability
                  SampleSize       = 200,   ## Add sampling error
                  ModApproxErrVar  = 0.1,   ## Add model approx error
                  NMinorFac        = 50,    ## Number of minor factors
                  epsTKL           = 0.2,   ## Spread of minor factor influence
                  SeedErrorFactors = 1,     ## Reproducible starting seed
                  SeedMinorFactors = 2,     ## Reproducible starting seed
                  PRINT            = FALSE, ## Suppress some output
                  LB               = FALSE, ## Do not set lower-bounds
                  LBVal            = 1,     ## Lower bound value (ignored)
                  Constant         = 0)     ## Do not add constant to data
                           
## Analyze new box data with added measurement error
fout <- faMain(X             = BoxData$BoxDataE,
               numFactors    = 3,
               facMethod     = 'fapa',
               rotate        = 'infomaxQ',
               targetMatrix  = ThurstoneSolution,
               bootstrapSE   = FALSE,
               rotateControl = 
                 list(numberStarts = 25, ## increase in real problem
                      standardize  = 'CM'),
               Seed          = 1)
               
## Summarize factor analytic output                
sout <- summary(object     = fout, 
                Set        = 1,
                PrintLevel = 1)
                
## Generate bootstrap samples
fout <- faMain(X             = BoxData$BoxDataE,
               numFactors    = 3,
               facMethod     = 'fapa',
               rotate        = 'infomaxQ',
               targetMatrix  = ThurstoneSolution,
               bootstrapSE   = TRUE,
               numBoot       = 25,   ## increase in real problem
               rotateControl = 
                 list(numberStarts = 1,
                      standardize  = 'CM'),
               Seed          = 1)

## Summarize factor analytic output with bootstraps
sout <- summary(object     = fout, 
                Set        = 1,
                PrintLevel = 2)  
                  
 ## To print a specific solution without computing diagnostics and 
   ## summary information, use the print function.
 
   print(fout, 
         Set = 1)                 
 
}
\references{
Cattell, R. (1978). The scientific use of factor analysis in behavioral and life sciences. 
 New York, New York, Plenum.
}
\seealso{
Other Factor Analysis Routines: \code{\link{BiFAD}},
  \code{\link{Box26}}, \code{\link{GenerateBoxData}},
  \code{\link{Ledermann}}, \code{\link{SLi}},
  \code{\link{SchmidLeiman}}, \code{\link{faAlign}},
  \code{\link{faEKC}}, \code{\link{faMain}},
  \code{\link{faScores}}, \code{\link{faSort}},
  \code{\link{faStandardize}}, \code{\link{faX}},
  \code{\link{fals}}, \code{\link{fapa}},
  \code{\link{fareg}}, \code{\link{orderFactors}},
  \code{\link{print.faMain}}, \code{\link{promaxQ}}
}
\author{
\itemize{
  \item Niels G. Waller (nwaller@umn.edu)
  \item Casey Giordano (Giord023@umn.edu)
  }
}
\concept{Factor Analysis Routines}
