% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{simplify_ftree}
\alias{simplify_ftree}
\title{Simplify a tree by keeping only significant components}
\usage{
simplify_ftree(tree, signifElt)
}
\arguments{
\item{tree}{a list of a matrix of component affectation
and a vector of coefficients of determination.}

\item{signifElt}{a vector of logical.
\code{TRUE} means
that deleting the component changes the component clustering.
\code{FALSE} means
that deleting the component does not change the clustering.}
}
\value{
Return a tree simplified,
 that is without less of components.
}
\description{
Take a tree,
then keep only the components identified in \code{signifElt}
by removing all other components.
}
\details{
A hierarchical tree is recorded
as a list of matrix of component affectation
and a vector of coefficients of determination.
The matrix of component affectation is a square matrix.
Its dimension is "number of leaves" = "number of components".
The clusters of components are labelled by integers, an integer by cluster.
The first line of the square matrix corresponds to the trivial cluster.
The trivial cluster get together all the components:
all components are thus labelled by one.
The second line separates the trivial cluster into 2 sub-clusters:
the components are labelled 1 or 2
according to the cluster to which they belong.
The following lines separate the trivial cluster into n sub-clusters,
labelled from 1 to the line numero.
The last line separate each component in a singleton cluster.\cr

The vector of coefficients of determination
determines the level of each split of a cluster into two new clusters.
}
\keyword{internal}
