% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelling.R
\name{shift_affectElt}
\alias{shift_affectElt}
\title{Renumber a vector of component affectation}
\usage{
shift_affectElt(affectElt)
}
\arguments{
\item{affectElt}{a vector of integers.
The vector contains the labels of the different functional groups
to which each component belongs.
Each functional group is labelled as an integer.}
}
\value{
Return a vector of component affectation.
}
\description{
Take a vector of component affectation
and change the cluster label \code{1} as the highest cluster label.
}
\details{
A hierarchical tree is recorded
as a list of matrix of component affectation
and a vector of coefficients of determination.
The matrix of component affectation is a square matrix.
Its dimension is "number of leaves" = "number of components".
The clusters of components are labelled by integers, an integer by cluster.
The first line of the square matrix corresponds to the trivial cluster.
The trivial cluster get together all the components:
all components are thus labelled by one.
The second line separates the trivial cluster into 2 sub-clusters:
the components are labelled 1 or 2
according to the cluster to which they belong.
The following lines separate the trivial cluster into n sub-clusters,
labelled from 1 to the line numero.
The last line separate each component in a singleton cluster.\cr

The initial trivial cluster is labelled \code{1} .
Consequently, the largest cluster remains labelled \code{1} .
The function \code{shift_affectElt} changes the cluster label \code{1}
as the highest cluster label.
Then decreases each other clusters number by \code{1}.\cr

The function is used to plot tree,
by sorting clusters from the most efficient cluster (on the left),
its size is generally smaller than the least efficient clusters,
towards the least efficient clusters (on the right).
}
\keyword{internal}
