% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{rss_total}
\alias{rss_total}
\title{Total Residual Sum of Squares of observed performances}
\usage{
rss_total(fobs, xpr, opt.mean)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
The used formula is \code{rss}
if each experiment has the same weight.
The used formula is \code{wrss}
(barycenter of RSS for each experiment)
if each experiment has different weights.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{xpr} is generated
by the function \code{stats::setNames}.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switchs to arithmetic formula if \code{opt.mean = "amean"}.
Switchs to geometric formula if \code{opt.mean = "gmean"}. \cr

Modelled performances are computed
using arithmetic mean (\code{opt.mean = "amean"})
or geometric mean (\code{opt.mean = "gmean"})
according to \code{opt.model}.}
}
\value{
Return the Total Residual Sum of Squares
of observed performances of assemblages.
Its value is computed according to \code{opt.mean}.
}
\description{
Take performance,
then compute the total Residual Sum of Squares.
}
\details{
None.
}
\keyword{internal}
