% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{fclust_write}
\alias{fclust_write}
\title{Record a functional clustering for one or several performances}
\usage{
fclust_write(fres = NULL, filename = "")
}
\arguments{
\item{fres}{a list containing predictions of assembly performances
and statistics computed by using a species clustering tree.
The list is generated
by the function \code{validate_ftree},
also called by the function \code{fclust}.}

\item{filename}{a string, used as radical for the 6 file names.}
}
\value{
Nothing. It is a procedure.
}
\description{
Write the results of a functional clustering
  in text format in 6 different files.
}
\details{
The results are splitted in 5 different files.

 \itemize{
 \item \code{"filename.options.csv"}{: contains \code{nbElt}, \code{nbAss},
   \code{nbXpr}, \code{"opt.method"}, \code{"opt.mean"},
   \code{"opt.model"}, \code{"opt.jack"},\code{"jack"},
   \code{"opt.na"}, \code{"opt.repeat"} and \code{"affectElt"}.}
 \item \code{"filename.inputs.csv"}{: contains \code{fobs}, \code{xpr}
    and \code{mOccur}.}
 \item \code{"filename.trees.csv"}{: contains
   the optimum number of functional clusters \code{nbOpt},
   and the hierarchical trees \code{tree.I} and \code{tree.II}.}
 \item \code{"filename.matrices.csv"}{: contains the matrices
   \code{mCal}, \code{mPrd}, \code{mMotifs}, \code{tCal}, \code{tPrd},
    and \code{tNbcl}.}
 \item \code{"filename.stats.csv"}{: contains both statistical matrices
 \code{mStats} and \code{tStats}.}
 }
}
\examples{

# save "res" in the files "myRecord.*".

res <-  CedarCreek.2004.res
filename <- tempfile(pattern = "myRecord", tmpdir = tempdir())

fclust_write(res, filename)


}
\seealso{
\code{\link{fclust}}: make a functional clustering,\cr
\code{\link{fclust_plot}}: plot the results of a functional clustering,\cr
\code{\link{fclust_write}}: save the results of a functional clustering,\cr
\code{\link{fclust_read}}: read the results of a functional clustering.\cr
}
