% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcc.R
\name{rpca_mfd}
\alias{rpca_mfd}
\title{Robust multivariate functional principal components analysis}
\usage{
rpca_mfd(
  mfdobj,
  center = "fusem",
  scale = "funmad",
  nharm = 20,
  method = "ROBPCA",
  alpha = 0.8
)
}
\arguments{
\item{mfdobj}{A multivariate functional data object of class mfd.}

\item{center}{If TRUE, it centers the data before doing MFPCA with respect
to the functional mean of the input data.
If \code{"fusem"}, it uses the functional M-estimator of location proposed
by Centofanti et al. (2023) to center the data.
Default is \code{"fusem"}.}

\item{scale}{If \code{"funmad"}, it scales the data before doing MFPCA using
the functional normalized median absolute deviation estimator
proposed by Centofanti et al. (2023).
If TRUE, it scales data using \code{scale_mfd}.
Default is \code{"funmad"}.}

\item{nharm}{Number of multivariate functional principal components
to be calculated. Default is 20.}

\item{method}{If \code{"ROBPCA"}, MFPCA uses ROBPCA of Hubert et al. (2005),
as described in Capezza et al. (2024).
If \code{"Locantore"}, MFPCA uses the Spherical Principal Components
procedure proposed by Locantore et al. (1999).
If \code{"Proj"}, MFPCA uses the Robust Principal Components based on
Projection Pursuit algorithm of Croux and Ruiz-Gazen (2005).
method If \code{"normal"}, it uses \code{pca_mfd} on \code{mfdobj}.
Default is \code{"ROBPCA"}.}

\item{alpha}{This parameter measures the fraction of outliers the algorithm
should resist and is used only if \code{method} is \code{"ROBPCA"}.
Default is 0.8.}
}
\value{
An object of \code{pca_mfd} class, as returned by the \code{pca_mfd}
function when performing non robust multivariate
functional principal component analysis.
}
\description{
It performs robust MFPCA as described in Capezza et al. (2024).
}
\examples{
library(funcharts)
dat <- simulate_mfd(nobs = 20, p = 1, correlation_type_x = "Bessel")
mfdobj <- get_mfd_list(dat$X_list, n_basis = 5)

# contaminate first observation
mfdobj$coefs[, 1, ] <- mfdobj$coefs[, 1, ] + 0.05

# plot_mfd(mfdobj) # plot functions to see the outlier
# pca <- pca_mfd(mfdobj) # non robust MFPCA
rpca <- rpca_mfd(mfdobj) # robust MFPCA
# plot_pca_mfd(pca, harm = 1) # plot first eigenfunction, affected by outlier
# plot_pca_mfd(rpca, harm = 1) # plot first eigenfunction in robust case

}
\references{
Capezza, C., Centofanti, F., Lepore, A., Palumbo, B. (2024)
Robust Multivariate Functional Control Charts.
\emph{Technometrics}, 66(4):531--547, \url{doi:10.1080/00401706.2024.2327346}.

Centofanti, F., Colosimo, B.M., Grasso, M.L., Menafoglio, A., Palumbo, B.,
Vantini, S. (2023)
Robust functional ANOVA with application to additive manufacturing.
\emph{Journal of the Royal Statistical Society Series C: Applied Statistics}
72(5), 1210–1234 \url{doi:10.1093/jrsssc/qlad074}

Croux, C., Ruiz-Gazen, A. (2005).
High breakdown estimators for principal components: The projection-pursuit
approach revisited.
\emph{Journal of Multivariate Analysis}, 95, 206–226,
\url{doi:10.1016/j.jmva.2004.08.002}.

Hubert, M., Rousseeuw, P.J., Branden, K.V. (2005)
ROBPCA: A New Approach to Robust Principal Component Analysis,
\emph{Technometrics} 47(1), 64--79, \url{doi:10.1198/004017004000000563}

Locantore, N., Marron, J., Simpson, D., Tripoli, N., Zhang, J., Cohen K.,
K. (1999),
Robust principal components for functional data.
\emph{Test}, 8, 1-28. \url{doi:10.1007/BF02595862}
}
\author{
C. Capezza, F. Centofanti
}
