% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{scale_mfd}
\alias{scale_mfd}
\title{Standardize Multivariate Functional Data.}
\usage{
scale_mfd(mfdobj, center = TRUE, scale = TRUE)
}
\arguments{
\item{mfdobj}{A multivariate functional data object of class \code{mfd}.}

\item{center}{A logical value, or a \code{fd} object.
When providing a logical value, if TRUE, \code{mfdobj} is centered,
i.e. the functional mean function is calculated and subtracted
from all observations in \code{mfdobj},
if FALSE, \code{mfdobj} is not centered.
If \code{center} is a \code{fd} object, then this function
is used as functional mean for centering.}

\item{scale}{A logical value, or a \code{fd} object.
When providing a logical value, if TRUE, \code{mfdobj}
is scaled after possible centering,
i.e. the functional standard deviation is calculated
from all functional observations in \code{mfdobj} and
then the observations are divided by this calculated standard deviation,
if FALSE, \code{mfdobj} is not scaled.
If \code{scale} is a \code{fd} object,
then this function is used as standard deviation function for scaling.}
}
\value{
A standardized object of class \code{mfd}, with two attributes,
if calculated,
\code{center} and \code{scale}, storing the mean and
standard deviation functions used for standardization.
}
\description{
Scale multivariate functional data contained
in an object of class \code{mfd}
by subtracting the mean function and dividing
by the standard deviation function.
}
\details{
This function has been written to work similarly
as the function \code{\link{scale}} for matrices.
When calculated, attributes \code{center} and \code{scale}
are of class \code{fd}
and have the same structure you get
when you use \code{fda::\link[fda]{mean.fd}}
and \code{fda::\link[fda]{sd.fd}}.
}
\examples{
library(funcharts)
mfdobj <- data_sim_mfd()
mfdobj_scaled <- scale_mfd(mfdobj)
}
