% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{sim_funcharts}
\alias{sim_funcharts}
\title{Simulate example data for funcharts}
\usage{
sim_funcharts(nobs1 = 1000, nobs_tun = 1000, nobs2 = 60)
}
\arguments{
\item{nobs1}{The number of observation to simulate in phase I. Default is 1000.}

\item{nobs_tun}{The number of observation to simulate the tuning data set. Default is 1000.}

\item{nobs2}{The number of observation to simulate in phase II. Default is 60.}
}
\value{
A list with three objects, \code{datI} contains the phase I data,
\code{datI_tun} contains the tuning data,
\code{datII} contains the phase II data.
In the phase II data, the first group of observations are in control,
the second group of observations contains a moderate mean shift,
while the third group of observations contains a severe mean shift.
The shift types are described in the paper from Capezza et al. (2022).
}
\description{
Function used to simulate three data sets to illustrate the use
of \code{funcharts}.
It uses the function \code{\link[funcharts]{simulate_mfd}},
which creates a data set with three functional covariates,
a functional response generated as a function of the
three functional covariates,
and a scalar response generated as a function of the
three functional covariates.
This function generates three data sets, one for phase I,
one for tuning, i.e.,
to estimate the control chart limits, and one for phase II monitoring.
see also \code{\link[funcharts]{simulate_mfd}}.
}
\references{
Centofanti F, Lepore A, Menafoglio A, Palumbo B, Vantini S. (2021)
Functional Regression Control Chart.
\emph{Technometrics}, 63(3), 281--294. <doi:10.1080/00401706.2020.1753581>

Capezza, C., Centofanti, F., Lepore, A., Menafoglio, A., Palumbo, B.,
& Vantini, S. (2022). funcharts: Control charts for multivariate
functional data in R. arXiv preprint arXiv:2207.09321.
}
