% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/face_removal_mask.R
\name{face_removal_mask}
\alias{face_removal_mask}
\alias{deface_image}
\title{Face Removal Mask}
\usage{
face_removal_mask(
  file,
  template = mni_fname(mm = "1"),
  face_mask = mni_face_fname(mm = "1"),
  outfile = NULL,
  dof = 12,
  cost = "mutualinfo",
  retimg = FALSE
)

deface_image(file, ...)
}
\arguments{
\item{file}{input image}

\item{template}{Template image  to register input image to.  Set 
to \code{NULL} (recommended)  if want to use from 
\url{https://github.com/poldracklab/pydeface}.
Alternatively, use \code{\link{mni_fname}}.}

\item{face_mask}{Mask of image, in same space as \code{template}.
Set to \code{NULL} (recommended) if want to use from 
\url{https://github.com/poldracklab/pydeface}. 
Alternatively, use \code{\link{mni_face_fname}}.}

\item{outfile}{Output file name}

\item{dof}{(numeric) degrees of freedom (default 6 - rigid body)}

\item{cost}{Cost function passed to \code{flirt}}

\item{retimg}{(logical) return image of class nifti}

\item{...}{not used}
}
\value{
An image or filename depending on \code{retimg}
}
\description{
Face Removal Mask
}
\examples{
\donttest{
if (have_fsl()) {
   file = "~/Downloads/sample_T1_input.nii.gz"
   if (file.exists(file)) {
       mask = face_removal_mask(file = file,
         template = NULL, face_mask = NULL)
       image = fslmask(file, mask)
   }
}
}
}
