% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covplot.R
\name{covplot}
\alias{covplot}
\title{Monitoring of the covariance matrix}
\usage{
covplot(
  out,
  xlim,
  ylim,
  xlab,
  ylab,
  main,
  lwd,
  lty,
  col,
  cex.lab,
  cex.axis,
  subsize,
  fg.thresh,
  fg.unit,
  fg.labstep,
  fg.lwd,
  fg.lty,
  fg.col,
  fg.mark,
  fg.cex,
  standard,
  fground,
  tag,
  datatooltip,
  trace = FALSE,
  ...
)
}
\arguments{
\item{out}{An object of S3 class \code{\link{fsmeda.object}} returned by
 \code{\link{fsmult}} with \code{monitoring=TRUE} -
 a list containing the monitoring of minimum Mahalanobis distance.

 The needed elements of \code{out} are
   \enumerate{
       \item \code{S2cov}: matrix containing the monitoring of the elements
         of the covariance matrix in each step of the forward search:
       \item \code{Un}: matrix containing the order of entry of each unit
               (necessary if datatooltip or databrush is selected).
       \item \code{X}: The data matrix.
     }}

\item{xlim}{Controls the \code{x} scale in the plot. \code{xlim} is a vector with two elements controlling
minimum and maximum on the \code{x}-axis. Default is to use automatic scale.}

\item{ylim}{Controls the \code{y} scale in the plot. \code{ylim} is a vector with two elements controlling
minimum and maximum on the \code{y}-axis. Default is to use automatic scale.}

\item{xlab}{A title for the x axis}

\item{ylab}{A title for the y axis}

\item{main}{An overall title for the plot}

\item{lwd}{The line width, a positive number, defaulting to 1}

\item{lty}{The line type. Line types can either be specified as an integer (1=solid (default), 2=dashed,
3=dotted, 4=dotdash, 5=longdash, 6=twodash) or as one of the character strings "solid",
"dashed", "dotted", "dotdash", "longdash", or "twodash".
The latter two are not supported by Matlab.}

\item{col}{Colors to be used for the highlighted units}

\item{cex.lab}{The magnification to be used for x and y labels relative to the current setting of cex}

\item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex}

\item{subsize}{Numeric vector containing the subset size with length equal to the number of columns of
matrix of mahalanobis distances. The default value of subsize is \code{(nrow(MAL) - ncol(MAL) + 1):nrow(MAL)}}

\item{fg.thresh}{(alternative to fg.unit) numeric vector of length 1 or 2 which specifies
the highlighted trajectories.
If \code{length(fg.thresh) == 1} the highlighted trajectories are those of units that throughtout
the search had at leat once a mahalanobis distance greater than \code{fg.thresh}.
The default value is \code{fg.thresh=2.5}. If \code{length(fg.thresh) == 2} the highlighted
trajectories are those of units that throughtout the search had a mahalanobis distance at
least once bigger than \code{fg.thresh[2]} or smaller than \code{fg.thresh[1]}.}

\item{fg.unit}{(alternative to fg.thresh), vector containing the list of the units to be highlighted.
If \code{fg.unit} is supplied, \code{fg.thresh} is ignored.}

\item{fg.labstep}{numeric vector which specifies the steps of the search where to put labels for
the highlighted trajectories (units). The default is to put the labels at the
initial and final steps of the search. \code{fg.labstep=''} means no label.}

\item{fg.lwd}{The line width for the highlighted trajectories (units). Default is 1.}

\item{fg.lty}{The line type for the highlighted trajectories (units). Line types can
either be specified as an integer (1=solid (default), 2=dashed,
3=dotted, 4=dotdash, 5=longdash, 6=twodash) or as one of the character strings "solid",
"dashed", "dotted", "dotdash", "longdash", or "twodash".
The latter two are not supported by Matlab.}

\item{fg.col}{colors to be used for the highlighted units.}

\item{fg.mark}{Controlls whether to plot highlighted trajectories as symbols.
if \code{fg.mark==TRUE} each line is plotted using a different
symbol else no marker is used (default).}

\item{fg.cex}{Controls the font size of the labels of the trajectories in foreground. If
\code{fg.cex=0} no labels will be shown - equivalent to \code{fg.labstop=""}.}

\item{standard}{MATLAB-style arguments -  appearance of the plot in terms of xlim, ylim, axes labels
and their font size style, color of the lines, etc.}

\item{fground}{MATLAB-style arguments - for the trajectories in foregroud.}

\item{tag}{Plot handle. String which identifies the handle of the plot which is about to be created.
The default is \code{tag='pl_mmd'}. Notice that if the program finds a plot which has
a tag equal to the one specified by the user, then the output of the new plot overwrites
the existing one in the same window else a new window is created.}

\item{datatooltip}{If datatooltip is not empty the user can use the mouse in order to have
information about the unit selected, the step in which the unit enters the search and
the associated label. If datatooltip is a list, it is possible to control the aspect
of the data cursor (see MATLAB function \code{datacursormode()} for more details or
see the examples below). The default options are \code{DisplayStyle="Window"} and \code{SnapToDataVertex="on"}.}

\item{trace}{Whether to print intermediate results. Default is \code{trace=FALSE}.}

\item{...}{potential further arguments passed to lower level functions.}
}
\value{
none
}
\description{
Plots the trajectories of the elements of the covariance (correlation) matrix monitored
}
\examples{

 \dontrun{
 X <- iris[,1:4]
 out <- fsmult(X, monitoring=TRUE)

 ##  Produce monitoring covariances plot with all the default options
 covplot(out)

 }

}
\author{
FSDA team, \email{valentin.todorov@chello.at}
}
