% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{subject.lobes}
\alias{subject.lobes}
\title{Load labels representing brain lobes.}
\usage{
subject.lobes(
  subjects_dir,
  subject_id,
  hemi = "both",
  include_cingulate = TRUE,
  as_annot = FALSE
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier}

\item{hemi}{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the surface file to be loaded. For 'both', see the information on the return value.}

\item{include_cingulate}{logical, whether to include the vertices of the cingulate in the lobes}

\item{as_annot}{return a hemilist of annotations instead of the return value described in the *value* section}
}
\value{
hemilist of integer vectors, the vectors represent vertex indices of the hemispheres, and each vertex is assigned one of the following values: `0`=no_lobe, `1`=frontal, `2`=parietal, `3`=temporal, `4`=occipital.
}
\description{
This gives you labels that represent brain lobes for a subject. The lobe definition is based on the Desikan-Killiany atlas (Desikan *et al.*, 2010) as suggested on the FreeSurfer website at https://surfer.nmr.mgh.harvard.edu/fswiki/CorticalParcellation.
}
\seealso{
Other atlas functions: 
\code{\link{get.atlas.region.names}()},
\code{\link{group.agg.atlas.native}()},
\code{\link{group.agg.atlas.standard}()},
\code{\link{group.annot}()},
\code{\link{group.label.from.annot}()},
\code{\link{label.from.annotdata}()},
\code{\link{label.to.annot}()},
\code{\link{regions.to.ignore}()},
\code{\link{spread.values.over.annot}()},
\code{\link{spread.values.over.hemi}()},
\code{\link{spread.values.over.subject}()},
\code{\link{subject.annot}()},
\code{\link{subject.atlas.agg}()},
\code{\link{subject.label.from.annot}()}

Other label functions: 
\code{\link{apply.label.to.morphdata}()},
\code{\link{apply.labeldata.to.morphdata}()},
\code{\link{subject.mask}()},
\code{\link{vis.labeldata.on.subject}()},
\code{\link{vis.subject.label}()}
}
\concept{atlas functions}
\concept{label functions}
