% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{get_mtime}
\alias{get_mtime}
\title{Get the \code{mtime} Attribute to or from an Object}
\usage{
get_mtime(x)
}
\arguments{
\item{x}{An object.}
}
\value{
The value of \code{attr(attr(x, "path", "mtime")}.
}
\description{
We set modification times on some objects, this is a convenience wrappers to
\code{\link{attr}}.
}
\examples{
x <- 2
path <- tempfile()
touch(path)
x <- set_path(x, path)
get_mtime(x)
}
\seealso{
Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
