% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_component}
\alias{bs_vars_component}
\title{Bootstrap components variables}
\usage{
bs_vars_component(
  padding_base_vertical = NULL,
  padding_base_horizontal = NULL,
  padding_large_vertical = NULL,
  padding_large_horizontal = NULL,
  padding_small_vertical = NULL,
  padding_small_horizontal = NULL,
  padding_xs_vertical = NULL,
  padding_xs_horizontal = NULL,
  line_height_large = NULL,
  line_height_small = NULL,
  border_radius_base = NULL,
  border_radius_large = NULL,
  border_radius_small = NULL,
  component_active_color = NULL,
  component_active_bg = NULL,
  caret_width_base = NULL,
  caret_width_large = NULL
)
}
\arguments{
\item{padding_base_vertical}{Vertical base padding.}

\item{padding_base_horizontal}{Horizontal base padding.}

\item{padding_large_vertical}{Vertical large padding.}

\item{padding_large_horizontal}{Horizontal large padding.}

\item{padding_small_vertical}{Vertical small padding.}

\item{padding_small_horizontal}{Horizontal small padding.}

\item{padding_xs_vertical}{Vertical extra small padding.}

\item{padding_xs_horizontal}{Horizontal extra small padding.}

\item{line_height_large}{Line height for large elements.}

\item{line_height_small}{Line height for small elements.}

\item{border_radius_base}{Base border radius.}

\item{border_radius_large}{Large border radius.}

\item{border_radius_small}{Small border radius.}

\item{component_active_color}{Color for active components.}

\item{component_active_bg}{Background color for active components.}

\item{caret_width_base}{Width for caret.}

\item{caret_width_large}{Widget for large caret.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 components padding and borders in Bootstrap and Bootswatch themes.
}
\examples{
bs_vars_component(
  padding_base_vertical = "5px",
  padding_base_horizontal = "20px",
  border_radius_base = 0,
  component_active_bg = "#0B610B"
)

if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    use_theme(
      create_theme(
        theme = "default",
        bs_vars_component(
          padding_base_vertical = "5px",
          padding_base_horizontal = "20px",
          border_radius_base = 0,
          component_active_bg = "#0B610B"
        ),
        output_file = NULL
      )
    ),
    tags$br(),
    actionButton("id", "A button"),
    wellPanel("A wellPanel"),
    panel(
      heading = "A panel",
      status = "primary",
      "Content"
    ),
    navlistPanel(
      "navlistPanel",
      tabPanel("First"),
      tabPanel("Second"),
      tabPanel("Third")
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
