% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_annot.R
\name{annot.unique}
\alias{annot.unique}
\title{Make the region names and indices unique across hemispheres for a parcellation.}
\usage{
annot.unique(
  annot,
  add_to_region_indices,
  region_name_prefix = "rh_",
  region_name_suffix = NULL,
  set_first_idx_zero = FALSE
)
}
\arguments{
\item{annot}{the annot in which to change the ids and names.}

\item{add_to_region_indices}{integer, a single value to add to the region indices. This is typically equal to the number of regions in the left hemisphere plus one (e.g., 36+1=37 for the 'aparc' atlas), as the region indices typically start at 0 and are consecutive, but you may want to check the maximal region id of the left hemi is in doubt. Pass \code{0} to leave the IDs intact.}

\item{region_name_prefix}{character string, a prefix to modify the region names to make them unique. Pass `NULL` if you do not want a prefix.}

\item{region_name_suffix}{character string, a suffix to modify the region names to make them unique.  Pass `NULL` if you do not want a suffix.}

\item{set_first_idx_zero}{logical, whether to apply special treatment to first region (the 'unknown' region) in annot and set its ID to \code{0}.}
}
\description{
Sometimes you need an annotation to use unique IDs and region names across hemispheres, but that is not the case for the standard FreeSurfer parcellations. So what you need to do is change the codes and names for one hemi. Typically the left hemi annot will be left as is, and the right hemi annot will be modified using this function.
}
\note{
This function is not part of the official API and should not be used. It is currently broken.
}
\examples{
\dontrun{
lh_annot = read.fs.annot("~/data/study1/subject1/label/lh.aparc.annot");
lh_annot; # shows info including region IDs
rh_annot = read.fs.annot("~/data/study1/subject1/label/rh.aparc.annot");
rh_annot_mod = annot.unique(rh_annot, annot.max.region.idx(lh_annot)+1L, region_name_prefix='rh_');
}

}
\keyword{internal}
