% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_weight.R
\name{write.fs.weight}
\alias{write.fs.weight}
\title{Write file in FreeSurfer weight format}
\usage{
write.fs.weight(filepath, vertex_indices, values, format = "bin")
}
\arguments{
\item{filepath, }{string. Full path to the output weight file.}

\item{vertex_indices}{vector of integers, the vertex indices. Must be one-based (R-style). This function will substract 1, as they need to be stored zero-based in the file.}

\item{values}{vector of floats. The brain morphometry data to write, one value per vertex.}

\item{format}{character string, one of 'bin' or 'asc'. The weight format type, there is a binary version of the format and an ASCII version.}
}
\description{
Write vertex-wise brain data for a set of vertices to file in *weight* format. This format is also known as *paint* format or simply as *w* format.
}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph.txt}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.weight.asc}()}
}
\concept{morphometry functions}
