% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_atlas_region_agg.R
\name{fs.atlas.region.agg}
\alias{fs.atlas.region.agg}
\title{Aggregate morphometry data over brain atlas regions for a subject.}
\usage{
fs.atlas.region.agg(vertex_morph_data, vertex_label_names,
  agg_fun = mean, requested_label_names = c())
}
\arguments{
\item{vertex_morph_data, }{numeric vector. The morphometry data, one value per vertex. The morphometry data are typically loaded from an MGZ or curv format file with the read.fs.curv or read.fs.mgh functions.}

\item{vertex_label_names, }{string vector. The region names for the vertices, one string per vertex. The region names are typically loaded from an annotation file with the read.fs.annot function.}

\item{agg_fun, }{function. An R function that aggregates data, typically max, mean, min or something similar. Note: this is NOT a string, put the function name without quotes. Defaults to mean.}

\item{requested_label_names, }{string vector. The label (or region) names that you want to occur in the output. If not specified, all region names which occur in the data are used. If given, and one of the requested names does NOT occur in the data, it will occur in the output with aggregation value NaN. If given, and one of the names from the data does NOT occur in the requested list, it will NOT occur in the output. So if you specify this, the output dataframe will contain a row for a region if and only if it is in the requested list.}
}
\value{
dataframe with aggregated values for all regions, with 2 columns and n rows, where n is the number of effective regions. The columns are: "region": string, contains the region name. "aggregated": numeric, contains the result of applying agg_fun to the morphometry data in that region.
}
\description{
Aggregate morphometry data over brain atlas regions, e.g., compute the mean thickness value over all regions in an atlas.
}
\keyword{internal}
