% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ste.R
\name{ste}
\alias{ste}
\title{Surrogate threshold effect for the one-step Joint surrogate model for the evaluation of a 
canditate surrogate endpoint.}
\usage{
ste(object, var.used = "error.estim", alpha. = 0.05, 
    pred.int.use = "up")
}
\arguments{
\item{object}{An object inheriting from \code{jointSurroPenal} class
(output from calling the function \code{jointSurroPenal}).}

\item{var.used}{This argument takes two values. The first one is \code{"error.estim"}
and indicates if the prediction error take into account
the estimation error of the estimates of the parameters. If the estimates 
are supposed to be known or if the dataset includes a high number of trials with 
a high number of subject per trial, value \code{No.error} can be used. 
The default is \code{error.estim}.}

\item{alpha.}{The confidence level for the prediction interval. The default is \code{0.05}}

\item{pred.int.use}{A character string that indicates the bound of the prediction interval 
to use to compute the STE. Possible values are \code{up} for the upper bound (the default)
or \code{lw} for the lower bound.}
}
\value{
Returns and displays the STE.
}
\description{
{
This function compute the surrogate threshold effect (STE) from the one-step joint 
surrogate \code{\link[=jointSurroPenal]{model}}. The STE is defined as the minimum treament effect on the surrogate 
necessary to predict a non-zero effect on the true endpoint (Burzykowski \emph{et al.}, 2006).
}
}
\details{
{  
The STE is obtained by solving the equation \eqn{l(\alpha_0) = 0} (resp. \eqn{u(\alpha_0) = 0}), where \eqn{\alpha_0} represents
the corresponding STE, and \eqn{l(\alpha_0)} (resp. \eqn{u(\alpha_0}) is the lower (resp. upper) bound of the prediction interval 
of the treatment effect on the true endpoint (\eqn{\beta + b_0}). Thereby,

\eqn{l(\alpha_0) \equiv 
E(\beta + b_0|\alpha_0, \vartheta) - Z_{1-(\gamma/2)} \sqrt(Var(\beta + b_0|\alpha_0, \vartheta))}

and 

\eqn{u(\alpha_0) \equiv 
E(\beta + b_0|\alpha_0, \vartheta) + Z_{1-(\gamma/2)} \sqrt(Var(\beta + b_0|\alpha_0, \vartheta))}

where \eqn{\vartheta} represents the set of estimates for the fixed-effects and the 
variance-covariance parameters of the random effects obtained from the joint surrogate 
\code{\link[=jointSurroPenal]{model}} 
(Sofeu \emph{et al.}, 2018). 

Given that negative values of treatment effect indicate a reduction of the risk 
of failure and are considered beneficial, STE is recommended to be computed from 
the upper prediction
limit \eqn{u(\alpha_0)}.

The details on the computation of STE is describes in 
Burzykowski \emph{et al.} (2006).
}
}
\examples{


\dontrun{


###--- Joint surrogate model ---###
###---evaluation of surrogate endpoints---###

data(dataOvarian)
joint.surro.ovar <- jointSurroPenal(data = dataOvarian, n.knots = 8, 
                init.kappa = c(2000,1000), indicator.alpha = 0, 
                nb.mc = 200, scale = 1/365)

# ======STE=====
# ste(joint.surro.ovar, var.used = "error.estim")
# Assuming no errors on the estimates
# ste(joint.surro.ovar, var.used = "No.error", pred.int.use = "up")

}


}
\references{
Burzykowski T, Buyse M (2006). "Surrogate threshold effect: an alternative 
measure for meta-analytic surrogate endpoint validation." Pharmaceutical 
Statistics, 5(3), 173-186.ISSN 1539-1612.

Sofeu C.L., Emura T. and Rondeau V. (2018). One-step validation method for surrogate 
endpoints in multiple randomized cancer clinical trials with failure-time endpoints.
}
\seealso{
\code{\link{jointSurroPenal}} \code{\link[=predict.jointSurroPenal]{predict}}
}
\author{
Casimir Ledoux Sofeu \email{casimir.sofeu@u-bordeaux.fr}, \email{scl.ledoux@gmail.com} and 
Virginie Rondeau \email{virginie.rondeau@inserm.fr}
}
\keyword{Surrogate}
\keyword{effect}
\keyword{prediction}
\keyword{ste}
\keyword{surrogate}
\keyword{threshold}
