% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fmm}
\alias{predict.fmm}
\title{Estimate the baseline hazard or the predict hazard rate based on the new data for non-penalized regression}
\usage{
##S3 method for class "fmm"
}
\arguments{
\item{object}{Object with class "fmm"}

\item{newdata}{The new data for prediction of hazard, categorical data has to be transformed to 0 and 1}

\item{surv}{Plot survival curve instead of cumulative hazard, the default is \code{FALSE}}

\item{...}{Further arguments pass to or from other methods}
}
\value{
\item{output}{A dataframe that the first column is the evaluated time point, the second column is the estimated cumulative
hazard or survival curve, the third column is the standard error of the estimation result and the fourth and fifth column
are the lower bound and upper bound based on 95 percent confidence interval.}
}
\description{
This function is used to estimate the baseline hazard or to predict the hazard rate of a specific individual
given result from model fitting.
}
\details{
If parameter \code{newdata} is given, the predicted hazard is calculated based on the given data.
If parameter \code{newdata} is not given, the estimation of baseline hazard will be returned. 
The confidence band is calculated based on the delta method. Please insure that the input of new data
should be of the same coefficient name as \code{object$coefname}. Note that if original data contains categorical data, you could check
\code{object$coefname} to input the corresponding 0 or 1 and name of coefficient for the \code{newdata}. 
For example, if the coefficient name is "sexfemale", then 1 denotes female while 0 denotes male. You may refer to the
example below to construct the new data.
}
\examples{

\donttest{
gam_re = frailtyMM(Surv(tstart, tstop, status) ~  sex + treat + cluster(id), cgd, frailty = "Gamma")

# Calculate the survival curve based on baseline hazard
predict(gam_re, surv = TRUE)

# Construct new data and calculate the cumulative hazard based on new data
newre = c(1, 1, 2)
names(newre) = c(gam_re$coefname, "id")
predict(gam_re, newdata = newre)
}

}
