% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractal_tree_model.R
\name{fractal_tree_model}
\alias{fractal_tree_model}
\title{Build a 2D L-System Tree from Predefined Tree Templates}
\usage{
fractal_tree_model(tree_model, n_iter)
}
\arguments{
\item{tree_model}{An integer or a character string specifying the desired tree model. The following models are available:
\itemize{
\item 1 or "binary_tree" (default \code{n_iter} = 6)
\item 2 or "alternate_tree" (default \code{n_iter} = 5)
\item 3 or "arrow_weed" (default \code{n_iter} = 5)
\item 4 or "twiggy_weed" (default \code{n_iter} = 5)
\item 5 or "stochastic_fuzzy_weed" (default \code{n_iter} = 4)
\item 6 or "crooked_binary_tree" (default \code{n_iter} = 6)
\item 7 or "crooked_alternate_tree" (default \code{n_iter} = 5)
\item 8 or "crooked_arrow_weed" (default \code{n_iter} = 5)
\item 9 or "crooked_twiggy_weed" (default \code{n_iter} = 5)
\item 10 or "crooked_stochastic_fuzzy_weed" (default \code{n_iter} = 4)
}}

\item{n_iter}{An integer specifying the number of iterations to build the tree. Each tree model has its own default value, but it can be overridden by specifying this parameter.}
}
\value{
A list representing the L-system tree structure after applying the specified number of iterations.
}
\description{
This function generates 2D L-system trees using predefined templates. Each template is based on a specific tree model, and the function allows you to control the number of iterations to generate the desired tree structure.
}
\details{
This function uses a set of predefined L-system rules to generate the tree structure. The rules for each tree model are stored in the \code{rules} data frame. The default number of iterations (\code{n_iter}) for each tree model is specified in the list above. If \code{n_iter} is not provided, the default value for the selected tree model will be used.
}
