% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fqi_metrics.R
\name{mean_c}
\alias{mean_c}
\title{Calculate Mean C}
\usage{
mean_c(x, key = "name", db, native = FALSE)
}
\arguments{
\item{x}{A data frame containing a list of plant species. This data frame
must have one of the following columns: \code{name} or \code{acronym}. For cover-weighted or
relative functions, this data frame must also have a column called \code{cover} containing
cover values and ideally a column containing plot IDs.}

\item{key}{A character string representing the column that will be used to join
the input data frame \code{x} with the regional FQA database. If a value is not specified, the
default is \code{"name"}. \code{"name"} and \code{"acronym"} are the only acceptable
values for \code{key}.}

\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}

\item{native}{Boolean (TRUE or FALSE). If TRUE, calculate metrics using only
native species.}
}
\value{
A non-negative integer
}
\description{
\code{mean_c} calculates the mean coefficient of conservatism for all species in the inventory
or along the transect.
}
\examples{
plant_list <- crooked_island

#mean c of all species (native and introduced)
mean_c(x = plant_list, key = "acronym", db = "michigan_2014", native = FALSE)

#mean c of native species
mean_c(x = plant_list, key = "acronym", db = "michigan_2014", native = TRUE)
}
