% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formattable.R
\name{formattable.POSIXct}
\alias{formattable.POSIXct}
\title{Create a formattable POSIXct vector}
\usage{
\method{formattable}{POSIXct}(x, ..., formatter = "format.POSIXct",
  preproc = NULL, postproc = NULL)
}
\arguments{
\item{x}{a vector of class \code{POSIXct}.}

\item{...}{arguments to be passed to \code{formatter}.}

\item{formatter}{formatting function, \code{format.POSIXct} in default.}

\item{preproc}{pre-processor function that prepares \code{x} for
formatting function.}

\item{postproc}{post-processor function that transforms formatted
output for printing.}
}
\value{
a \code{formattable} POSIXct vector
}
\description{
Create a formattable POSIXct vector
}
\examples{
times <- as.POSIXct("2015-04-10 09:30:15") + 1:5
ftimes <- formattable(times, format = "\%Y\%m\%dT\%H\%M\%S")
ftimes
ftimes + 30
}

