% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_matrix.R
\name{similarity_matrix}
\alias{similarity_matrix}
\title{Get the similarity matrix of an area}
\usage{
similarity_matrix(
  df,
  species,
  comparison,
  NI_label = "",
  index = "Sorensen",
  dendrogram = FALSE,
  n_groups = 3
)
}
\arguments{
\item{df}{A data frame.}

\item{species}{Quoted name of the scientific names variable, or any variable used to differentiate the different species found in data. If supplied, will be used to classify the species in the diameter data.}

\item{comparison}{Quoted name of the variable containing levels to be compared with each other.}

\item{NI_label}{Label used for Species not identified. This parameter works along with species. The level supplied here will not be considered in the classification. Default \code{""}.}

\item{index}{Character value for the desired index to be used. Can be either \code{"Jaccard"}, for a matrix based on the Jaccard index of similarity, \code{"Sorensen"}, for a matrix based the Sorensen index of similarity, or \code{"all"}, for a list with matrices for both indexes. Default: \code{"Sorensen"}.}

\item{dendrogram}{If \code{TRUE}, a dendrogram will also be created. Default: \code{FALSE}.}

\item{n_groups}{Number of groups in the dendrogram. Default \code{3}.}
}
\value{
a matrix object with a similarity matrix, or a list, according to the \code{"index"} and \code{"dendrogram"} arguments.
}
\description{
Calculates the Jaccard similarity index and Sorensen similarity index.
}
\examples{
library(forestmangr)
data("exfm20")
head(exfm20)

# To get the similarity matrix of an area, we simply need to provide
# the species variable name, and a subdivision variable name, like
# transect. By default we get a a matrix based on the Sorensen index:
similarity_matrix(exfm20, "scientific.name", "transect")

# To get the similarity matrix of Jaccard, use the index argument:
similarity_matrix(exfm20, "scientific.name", "transect", index = "Jaccard")

# To get a dendrogram with the matrix, use dendrogram=TRUE:
similarity_matrix(exfm20, "scientific.name", "transect", index = "Jaccard", dendrogram = TRUE)

# To get a list with both matrices, use index="all":
similarity_matrix(exfm20, "scientific.name", "transect", index = "all")

# If the data supplied only has 2 levels, a paired comparison is made instead:
ex_pair <- exfm20[exfm20$transect \%in\% c("T01", "T02") , ]
ex_pair

similarity_matrix(ex_pair, "scientific.name", "transect", index = "all")

}
\references{
Souza, A. L. and Soares, C. P. B. (2013) Florestas Nativas: estrutura, dinamica e manejo. Vicosa: UFV.
}
\author{
Eric Bastos Gorgens \email{e.gorgens@gmail.com}
}
