% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_datasets.R
\docType{data}
\name{growth_spatial_ex}
\alias{growth_spatial_ex}
\title{Example growth data frame with spatial data for small example}
\format{
A \code{sf} spatial tibble

\describe{
\item{ID}{Tree identification number. This identifies an individual tree and
can be used to connect trees between the two censuses.}
\item{sp}{Species of the individual}
\item{codes1}{Code for additional information on the stem during the first census: M means the main stem
of the individual tree and R means the stem was lost, but the tag was moved to another stem greater than DBH cutoff,
this stands for resprout.}
\item{dbh1}{Diameter at breast height of the tree in cm at the first census}
\item{dbh2}{Diameter at breast height of the tree in cm at the second census}
\item{growth}{Average annual growth between the two censuses in cm per year}
\item{codes2}{Codes at the second census}
\item{geometry}{Point location of the individual}
\item{buffer}{A boolean variable for whether the individual is in the buffer region or not}
\item{foldID}{Which cross-validation fold the individual is in}
}
}
\usage{
growth_spatial_ex
}
\description{
This is an example growth data frame formed from two census data frames which
has been updated with spatial data. It starts from \link{growth_ex}.
}
\examples{
library(ggplot2)
library(dplyr)
library(sf)

comp_dist <- 1

ggplot() +
  geom_sf(data = growth_spatial_ex, aes(col = buffer), size = 2)

ggplot() +
  geom_sf(data = growth_spatial_ex, aes(col = foldID), size = 2)

# Create the focal versus comp data frame
focal_vs_comp_ex <- growth_spatial_ex \%>\%
  mutate(basal_area = 0.0001 * pi * (dbh1 / 2)^2) \%>\%
  create_focal_vs_comp(comp_dist, blocks = blocks_ex, id = "ID", comp_x_var = "basal_area")
}
\seealso{
\code{\link[=compute_growth]{compute_growth()}}

Other example data objects: 
\code{\link{blocks_ex}},
\code{\link{census_1_ex}},
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{census_2_ex}},
\code{\link{comp_bayes_lm_ex}},
\code{\link{focal_vs_comp_ex}},
\code{\link{growth_ex}},
\code{\link{growth_toy}},
\code{\link{species_bw}},
\code{\link{study_region_bw}},
\code{\link{study_region_ex}}
}
\concept{example data objects}
\keyword{datasets}
