% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_datasets.R
\docType{data}
\name{blocks_ex}
\alias{blocks_ex}
\title{Example cross validation grid}
\format{
A \code{sf} polygons

\describe{
\item{foldID}{Tree identification number. This identifies an individual tree and
can be used to connect trees between the two censuses.}
\item{geometry}{Point location of the individual}
}
}
\usage{
blocks_ex
}
\description{
This is an example cross validation grid. This is needed to create the focal versus
comp data frame and run cross-validated models
}
\examples{
library(ggplot2)
library(sf)

comp_dist <- 1

ggplot(blocks_ex) +
  geom_sf() +
  geom_sf(data = growth_spatial_ex)

focal_vs_comp_ex <- growth_spatial_ex \%>\%
  create_focal_vs_comp(comp_dist, blocks = blocks_ex, id = "ID")
}
\seealso{
Other example data objects: 
\code{\link{census_1_ex}},
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{census_2_ex}},
\code{\link{comp_bayes_lm_ex}},
\code{\link{focal_vs_comp_ex}},
\code{\link{growth_ex}},
\code{\link{growth_spatial_ex}},
\code{\link{growth_toy}},
\code{\link{species_bw}},
\code{\link{study_region_bw}},
\code{\link{study_region_ex}}
}
\concept{example data objects}
\keyword{datasets}
