% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_counts_to_freqs.R
\name{allele_counts_to_freqs}
\alias{allele_counts_to_freqs}
\title{Convert allele counts data frame to list of frequencies by locus}
\usage{
allele_counts_to_freqs(x, remove_zeroes = TRUE)
}
\arguments{
\item{x}{A data fram with columns: \code{locus}, \code{allele}, and
\code{count}.}

\item{remove_zeroes}{Logical. Should zero-count alleles be removed? Default
is \code{TRUE}.}
}
\value{
Named list with frequencies per locus. Each element is a named
        numeric vector of allele frequencies.
        An attribute \code{N} gives the number of allele observations per
        locus.
}
\description{
Convert allele counts data frame to list of frequencies by locus
}
\examples{
x <- data.frame(
  locus = "D3S1358",
  allele = c("12", "13", "14", "15", "15.2", "16", "17", "18", "19"),
  count = c(3, 2, 62, 211, 1, 218, 145, 39, 3)
)
freqs <- allele_counts_to_freqs(x)
freqs
attr(freqs, "N")
}
