% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_forecasts.R
\name{plot.forecastML}
\alias{plot.forecastML}
\title{Plot an object of class 'forecastML'}
\usage{
\method{plot}{forecastML}(
  x,
  data_actual = NULL,
  actual_indices = NULL,
  facet = ~model,
  models = NULL,
  group_filter = NULL,
  drop_facet = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class 'forecastML' from \code{combine_forecasts()}.}

\item{data_actual}{A data.frame containing the target/outcome name and any grouping columns.
The data can be historical actuals and/or holdout/test data.}

\item{actual_indices}{Required if \code{data_actual} is given. A vector or 1-column data.frame
of numeric row indices or dates (class 'Date' or 'POSIXt') with length \code{nrow(data_actual)}.
The data can be historical actuals and/or holdout/test data.}

\item{facet}{Optional. A formula with any combination of \code{model}, or \code{group} (for grouped time series)
passed to \code{ggplot2::facet_grid()} internally (e.g., \code{~ model}, \code{model ~ .}, \code{~ model + group}).}

\item{models}{Optional. Filter results by user-defined model name from \code{train_model()}.}

\item{group_filter}{Optional. A string for filtering plot results for grouped time-series (e.g., \code{"group_col_1 == 'A'"});
passed to \code{dplyr::filter()} internally.}

\item{drop_facet}{Optional. Boolean. If actuals are given when forecasting factors, the plot facet with 'actual' data can be dropped.}

\item{...}{Not used.}
}
\value{
Forecast plot of class 'ggplot'.
}
\description{
A forecast plot of h-step-ahead forecasts produced from multiple horizon-specific forecast models
using \code{combine_forecasts()}.
}
