% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drift_corrections_03.R
\name{baseline_corr}
\alias{baseline_corr}
\title{Automatic or Manual Baseline Correction of Time Series}
\usage{
baseline_corr(
  filename,
  corr.type = "auto",
  window.size.mins = 1000,
  window.size.means = NULL,
  quantile.size = 0.05,
  y.scale = 0.5,
  res.reduction = 10,
  Hz = 100,
  plot.to.screen = FALSE,
  write.data = FALSE,
  write.PDFs = FALSE,
  write.logs = FALSE,
  output.folder = NULL,
  show.progress = FALSE
)
}
\arguments{
\item{filename}{A character string containing the full path to the measurement file that needs correction.
See Details for info on what the file should look like.}

\item{corr.type}{Character string defining the desired mode of baseline correction. One of \code{"auto"}
or \code{"manual"}. Default: \code{"auto"}}

\item{window.size.mins}{A numeric value for the size of the search window to find minima in. Should be
in the same time unit as the measurement. Longer peaks require higher values, shorter peaks require
smaller values. Default: \code{1000}.}

\item{window.size.means}{A numeric value for the size of the window to average the minima in. Should be
in the same time unit as the measurement. By default (\code{NULL}), the same value as specified for
\code{window.size.mins} is used.}

\item{quantile.size}{A numerical value between \code{0} and \code{1} to define the quantile which is treated as
the 'minimum' of a sliding window. Default: \code{0.05}.}

\item{y.scale}{A numeric value to reduce the y-axis range during plotting. This simplifies the manual
placement of the points during the manual correction procedure.}

\item{res.reduction}{A numeric value to reduce the number of time steps by during plotting. Speeds up
the plotting process and reduces PDF size. Has no effect on the results, only on the plots. Default: \code{10}.}

\item{Hz}{A numeric value to reduce sampling frequency for temporary analyses. This works as a smoothing
filter during temporary analyses and does not reduce the actual sampling frequency of the data.
Default: \code{100}.}

\item{plot.to.screen}{A logical value indicating if results should be
plotted in the current R plot device. Default: \code{FALSE}.}

\item{write.data}{A logical value indicating if drift-corrected file should
be saved. If yes, it will be saved in \code{output.folder}.
Default: \code{FALSE}.}

\item{write.PDFs}{A logical value indicating whether results should be saved
as PDFs. Does not slow
down the process as much as printing to the R plot device and is considered
necessary to quality check the results. If yes, it will be saved in
\code{output.folder/PDFs}. Default: \code{FALSE}.}

\item{write.logs}{A logical value indicating whether a log file with
information on the method and values used to correct the baseline drift should be
saved. Is considered necessary for reproducibility. If yes, it will be saved
in \code{output.folder/logs}. Default: \code{FALSE}.}

\item{output.folder}{Path to folder where data, PDF and log files should
be stored. Default: \code{NULL.}}

\item{show.progress}{A logical value indicating if progress should be
printed to the console. Default: \code{FALSE}.}
}
\value{
Returns a tibble containing the amplifier baseline drift-corrected data in the
following format\tabular{ccc}{
   \code{t} \tab  \tab \code{y} \cr
   \code{t.1} \tab  \tab \code{y.2} \cr
   \code{...} \tab  \tab \code{...} \cr
   \code{t.n} \tab  \tab \code{y.n} \cr
}
}
\description{
If baseline (zero-line) of measurement is unstable (e.g. due to temperature fluctuations, wind, ...),
the baseline needs to be continually adjusted throughout the measurement. This script allows an
automatic adjustment of the baseline.
The automatic approach invokes a sliding window, during which the 'minimum' within each sliding window
is stored. A 'minimum' is defined by the \code{quantile.size}: if set to \code{0.05}, the value below which only 5\% of
the measurement data within the sliding window lies, is treated as the current window's minimum. This
prevents the treatment of potential artifacts as minima. In a second iteration, another sliding window
calculates the average of these 'minima'. The resulting values are subtracted from
the original time series. This approach works well for time series with relatively short peaks.
If the automatic approach does not yield acceptable results, an interactive manual approach to correct
the baseline can be performed instead.
}
\details{
\code{forceR} generally expects file names to start with a leading number specifying the
measurement number (E.g. "0001_G_maculatus.csv"). The number ("0001") is used to
keep data files, log files, and PDF files of the same measurement associated
with each other.

The input files should to be in the following format:\tabular{ccc}{
   \code{t} \tab  \tab \code{y} \cr
   \code{t.1} \tab  \tab \code{y.2} \cr
   \code{...} \tab  \tab \code{...} \cr
   \code{t.n} \tab  \tab \code{y.n} \cr
}


In case there are more than two columns, only the first two columns will be used. If the first two columns
are not named 't' and 'y', they will be renamed.
}
\examples{
#'########### AUTOMATIC MODE
# define file to apply the baseline drift correction to
filename <- forceR_example(type = "ampdriftcorr")

# run automatic baseline drift corrections without saving files or
#   printing to screen:
file.baseline_corr <- baseline_corr(filename = filename,
                                     corr.type = "auto",
                                     window.size.mins = 1000,
                                     window.size.means = NULL,
                                     quantile.size = 0.05,
                                     y.scale = 0.5,
                                     res.reduction = 10,
                                     Hz = 100,
                                     plot.to.screen = FALSE,
                                     write.data = FALSE,
                                     write.PDFs = FALSE,
                                     write.logs = FALSE,
                                     show.progress = FALSE)

file.baseline_corr

#'########### MANUAL MODE

# define file to apply the baseline drift correction to
filename <- forceR_example(type = "ampdriftcorr")

# run interactive baseline drift corrections with saving files and
#   printing to screen:  - out-commented to pass package tests

# file.baseline_corr <- baseline_corr(filename = filename,
#                                       corr.type = "manual",
#                                       window.size.mins = 1000,
#                                       window.size.means = NULL,
#                                       quantile.size = 0.05,
#                                       y.scale = 0.5,
#                                       res.reduction = 10,
#                                       Hz = 100,
#                                       plot.to.screen = TRUE,
#                                       output.folder = "./baselinecorr",
#                                       show.progress = TRUE)

# file.baseline_corr
}
