% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume.total.R
\name{volume.total}
\alias{volume.total}
\title{Volumetric calculus of organisms}
\usage{
\method{volume}{total}(data, model, ...)
}
\arguments{
\item{data}{data frame containing size data. Size data parameters may vary according to chosen model, see Details.}

\item{model}{character informing geometric model to calculate volume, the models options are listed below:
\itemize{
  \item \code{'1hl'} : sphere
  \item \code{'2sl'} : half-sphere
  \item \code{'3hl'} : prolate spheroid
  \item \code{'4hl'} : cone or double cone
  \item \code{'6fs'} : paraboloid
  \item \code{'7fs'} : dome
  \item \code{'8hl'} : cylinder
  \item \code{'10hl'} : ellipsoid
  \item \code{'11fs'} : elliptic cone
  \item \code{'12v'} : cone + half ellipsoid
  \item \code{'13hlsl'} : gomphonemoid
  \item \code{'14hl'} : prism on elliptic base/elliptic cylinder
  \item \code{'15hl'} : half elliptic prism
  \item \code{'17fs'} : triangular dypyramid
  \item \code{'ahx'} : area x height

}}

\item{...}{other parameters.}
}
\value{
A `data.frame` or numeric object, consisting of calculated individual volume along with biovolume if the \code{pco} is informed.
}
\description{
The function calculates organisms volume based on geometric approximation.
}
\details{
These geometric models applied in this function are based and adapted from microalgae models developed by Hillebrand et al. (1999) - \code{('.hl')}, Sun and Liu (2003) - \code{('.sl')} and Vadrucci, Cabrini and Basset (2007) - \code{('.v')}, plus other adapted models \code{('.fs')}.
The models can be a variable in \code{data} if specified as \code{model}.The size data parameters should follow the specified measures determined by each model, where \eqn{d_one} is minor diameter, \eqn{d_two} is major diameter and \eqn{h} is height.
\tabular{ll}{
  \code{'1hl'}
  \tab \eqn{V = (pi * (d_one^3))/6}
  \cr
  \code{'2sl'}
  \tab \eqn{V = (pi * (d_one^3))/12}
  \cr
  \code{'3hl'}
  \tab \eqn{V = (pi * h * (d_one^2))/6}
  \cr
  \code{'4hl'}
  \tab \eqn{V = (pi * h * (d_one^2))/12}
  \cr
  \code{'6fs'}
  \tab \eqn{V = (pi * hx * (d_one^2))/8}
  \cr
  \tab where \eqn{hx} is a function of test height for trochamminids.
  \cr
  \code{'7fs'}
  \tab \eqn{V = (pi * h * (4 * (h^2) + 3 * (d_one^2)))/24}
  \cr
  \code{'8hl'}
  \tab \eqn{V = (pi * h * (d_one^2))/4}
  \cr
  \code{'10hl'}
  \tab \eqn{V = (pi * h * d_one * d_two)/6}
  \cr
  \code{'11fs'}
  \tab \eqn{V = (pi * h * d_one * d_two)/12}
  \cr
  \code{'12v'}
  \tab \eqn{V = (pi * h * d_one * d_two)/12}
  \cr
  \code{'13hlsl'}
  \tab \eqn{V = ((d_one * d_two)/4) * (d_one + ((pi/4) - 1) * d_two) * asin(h/(2*d_one))}
  \cr
  \code{'14hl'}
  \tab \eqn{V = (pi * h * d_one * d_two)/4}
  \cr
  \code{'15hl'}
  \tab \eqn{V = pi * h * d_one * d_two)/4}
  \cr
  \code{'17fs'}
  \tab \eqn{V = ((length * width)/2) * h)/3}
  \cr

}
}
\examples{
#Ammonia size data
data("ammonia")

#calculate test volume
volume.total(ammonia, model = "10hl")


}
\references{
\itemize{
  \item Hillebrand, H., Dürselen, C.D., Kirschtel, D., Pollingher, U., & Zohary, T. (1999). Biovolume calculation for pelagic and benthic microalgae. \emph{Journal of Phycology}, 35(2), 403–424. \emph{doi:10.1046/j.1529-8817.1999.3520403.x}
  \item Sun, J., & Liu, D. (2003). Geometric models for calculating cell biovolume and surface area for phytoplankton. \emph{Journal of Plankton Research}, 25(11), 1331–1346. \emph{doi:10.1093/plankt/fbg096}
  \item Vadrucci, M. R., Cabrini, M., & Basset, A. (2007). Biovolume determination of phytoplankton guilds in transitional water ecosystems of Mediterranean Ecoregion. \emph{Transitional Waters Bulletin}, 2, 83–102. \emph{doi:10.1285/i1825229Xv1n2p83}
}
}
\seealso{
\code{\link{measure}}

\code{\link{bio.volume}}
}
\author{
Thaise R. Freitas \email{thaisericardo.freitas@gmail.com}
}
