% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical.R
\docType{data}
\name{verre}
\alias{verre}
\title{French Medieval Glass Composition}
\format{
A \code{\link{data.frame}} with 17 variables:
\describe{
\item{Site}{\code{CNL}: Cour Napoléon, Louvre; \code{ORL}: Orléans;
\code{POI}: Poitiers; \code{ANG}: Angers; \code{OMO}: Omonville, Seine Maritime;
\code{ROU}: Rouen; \code{MEA}: Meaux; \code{CHL}: Châlons-sur-Marne;
\code{PAI}: Pairu (Argonne, Ardennes); \code{BER}: Bercettes (Argonne, Ardennes);
\code{BIN}: Binois (Argonne, Ardennes); \code{CHE}: Chevrie (Argonne, Ardennes);
\code{MIT}: Mitte (Argonne, Ardennes); \code{MET}: Metz; \code{CHM}: Chambaran.}
\item{Sample}{Sample code.}
\item{Type}{Typology.}
\item{Age}{Century.}
\item{Periode}{\code{I}: 9th-12th century; \code{II}: 13th-first half of the 15th
century; \code{III}: end of the 15th to end of the 16th century;
\code{IV}: end of 16th to end of the 17th century.}
\item{Tint}{\code{B}: blue; \code{CL}: colourless; \code{CLg} colourless (greyish tint);
\code{PB}: pale blue; \code{PGE}: pale greenish;
\code{PGE-B}: pale green-blue or blue-green;
\code{PGY-B}: pale grey-blue; \code{R}: opaque red; \code{W}: opaque white;
\verb{*av}: added aventurine spots;
\verb{*bl}: added thread blue or blue spots;
\verb{*r}: added thread opaque red or opaque red spots;
\verb{*w}: added thread opaque white.}
\item{Na2O}{Na2O content (percent).}
\item{CaO}{CaO content (percent).}
\item{K2O}{K2O content (percent).}
\item{MgO}{MgO content (percent).}
\item{P2O5}{P2O5 content (percent).}
\item{SiO2}{SiO2 content (percent).}
\item{Al2O3}{Al2O3 content (percent).}
\item{FeO}{FeO content (percent).}
\item{MnO}{MnO content (percent).}
\item{Cl}{Cl content (percent).}
\item{Reference}{Site reference.}
}
}
\usage{
verre
}
\description{
Chemical analysis (electron probe X-ray micro analysis) of 398 medieval
glass vessels found in France.
}
\examples{
plot(
  x = verre$Na2O,
  y = verre$CaO / (verre$CaO + verre$K2O),
  type = "p",
  xlab = expression("Na"[2]*"O (\%)"),
  ylab = expression("CaO"/"(CaO"+"K"[2]*"O)")
)
}
\references{
Barrera J., Velde B. (1989). A study of french medieval glass composition.
\emph{Archéologie médiévale}, 19, 81-130. \doi{10.3406/arcme.1989.953}.
}
\seealso{
Other chemical data: 
\code{\link{kommos}}
}
\concept{chemical data}
\keyword{datasets}
