% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_number.R
\name{plot.factor.number}
\alias{plot.factor.number}
\title{Plot factor number}
\usage{
\method{plot}{factor.number}(x, ...)
}
\arguments{
\item{x}{\code{factor.number} object}

\item{...}{not used}
}
\value{
NULL, printed to console
}
\description{
Plots the eigenvalue ratio or information criteria from a \code{factor.number} object
}
\examples{
library(fnets)

## Alessi, Barigozzi, and Capasso method for restricted models
set.seed(123)
n <- 500
p <- 50
common <- sim.restricted(n, p)
idio <- sim.var(n, p)
x <- common$data * apply(idio$data, 1, sd) / apply(common$data, 1, sd) + idio$data

abc <- factor.number(x, fm.restricted = TRUE)
print(abc)
plot(abc)

## Eigenvalue ratio method
er <- factor.number(x, method = "er", fm.restricted = TRUE)
print(er)
plot(er)

## Hallin and Liška method for unrestricted models
set.seed(123)
n <- 500
p <- 50
common <- sim.unrestricted(n, p)
idio <- sim.var(n, p)
x <- common$data * apply(idio$data, 1, sd) / apply(common$data, 1, sd) + idio$data

hl <- factor.number(x, fm.restricted = FALSE)
print(hl)
plot(hl)
}
\seealso{
\link[fnets]{factor.number}
}
